/*
 * Decompiled with CFR 0.152.
 */
package marytts.fst;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import marytts.fst.AlignerTrainer;
import marytts.fst.FSTLookup;
import marytts.fst.StringPair;
import marytts.fst.Trie;

public class TransducerTrie
extends Trie<StringPair> {
    static int ARCOFFSET_BITS = 20;
    static int OVERALL_BITS = 32;
    static int LABELID_BITS = OVERALL_BITS - (ARCOFFSET_BITS + 1);

    public void writeFST(DataOutputStream out, String encoding) throws IOException {
        StringPair ioSym;
        if (this.reprs == null) {
            throw new IllegalStateException("Cannot write transducer: first compute minimization of trie.");
        }
        int[] arcOffsets = new int[this.reprs.size() + 1];
        arcOffsets[0] = 1;
        int i = 0;
        while (i < this.rlist.size()) {
            arcOffsets[i + 1] = arcOffsets[i] + ((Trie.TrieNode)this.rlist.get(i)).getArcMap().size();
            if (((Trie.TrieNode)this.rlist.get((int)i)).isFinal) {
                int n = i + 1;
                arcOffsets[n] = arcOffsets[n] + 1;
            }
            ++i;
        }
        int maxAO = arcOffsets[arcOffsets.length - 1];
        if (maxAO >> ARCOFFSET_BITS != 0) {
            int numBitsNeeded = (int)Math.ceil(Math.log(maxAO) / Math.log(2.0));
            throw new IOException("Cannot write transducer: too many arcs to be encoded in binary fst format (would need " + numBitsNeeded + " bits, have " + ARCOFFSET_BITS + ")");
        }
        int maxLID = this.labels.size() + 2;
        if (maxLID >> LABELID_BITS != 0) {
            int numBitsNeeded = (int)Math.ceil(Math.log(maxLID) / Math.log(2.0));
            throw new IOException("Cannot write transducer: too many arc-labels to be encoded in binary fst format (would need " + numBitsNeeded + " bits, have " + LABELID_BITS + ")");
        }
        if (!Charset.isSupported(encoding)) {
            throw new IOException("Cannot write transducer: encoding not supported.");
        }
        out.writeInt(encoding.length());
        out.write(encoding.getBytes("UTF-8"));
        out.writeInt(OVERALL_BITS);
        out.writeInt(ARCOFFSET_BITS);
        out.writeInt(maxAO);
        int startArc = arcOffsets[this.root.getId()] | 0x100000 | Integer.MIN_VALUE;
        out.writeInt(startArc);
        for (Trie.TrieNode repr : this.rlist) {
            ArrayList<Integer> arcVals = new ArrayList<Integer>();
            for (Integer labelId : repr.getArcMap().keySet()) {
                int targetId = repr.getArcMap().get(labelId).getId();
                arcVals.add(arcOffsets[targetId] | labelId + 2 << 20);
            }
            if (repr.isFinal) {
                arcVals.add(arcOffsets[repr.getId()] | Integer.MIN_VALUE);
            } else {
                int last = arcVals.size() - 1;
                arcVals.set(last, (Integer)arcVals.get(last) | Integer.MIN_VALUE);
            }
            for (Integer val : arcVals) {
                out.writeInt(val);
            }
        }
        int[] labelOffsets = new int[this.labels.size() * 2];
        labelOffsets[0] = 4;
        int i2 = 0;
        while (i2 < this.labels.size()) {
            ioSym = (StringPair)this.labels.get(i2);
            labelOffsets[i2 * 2 + 1] = labelOffsets[i2 * 2];
            int n = i2 * 2 + 1;
            labelOffsets[n] = labelOffsets[n] + ioSym.getString1().getBytes(encoding).length;
            int n2 = i2 * 2 + 1;
            labelOffsets[n2] = labelOffsets[n2] + 1;
            if (i2 + 1 < this.labels.size()) {
                labelOffsets[(i2 + 1) * 2] = labelOffsets[i2 * 2 + 1];
                int n3 = (i2 + 1) * 2;
                labelOffsets[n3] = labelOffsets[n3] + ioSym.getString2().getBytes(encoding).length;
                int n4 = (i2 + 1) * 2;
                labelOffsets[n4] = labelOffsets[n4] + 1;
            }
            ++i2;
        }
        out.writeInt(this.labels.size() + 2);
        out.writeShort(0);
        out.writeShort(1);
        out.writeShort(2);
        out.writeShort(3);
        i2 = 0;
        while (i2 < this.labels.size()) {
            out.writeShort(labelOffsets[i2 * 2]);
            out.writeShort(labelOffsets[i2 * 2 + 1]);
            ++i2;
        }
        out.writeByte(0);
        out.writeByte(0);
        out.writeByte(0);
        out.writeByte(0);
        i2 = 0;
        while (i2 < this.labels.size()) {
            ioSym = (StringPair)this.labels.get(i2);
            out.write(ioSym.getString1().getBytes(encoding));
            out.writeByte(0);
            out.write(ioSym.getString2().getBytes(encoding));
            out.writeByte(0);
            ++i2;
        }
    }

    public static void main(String[] args) throws IOException {
        String path = "/Users/benjaminroth/Desktop/mary/fst/german/";
        BufferedReader lexReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(String.valueOf(path) + "lexicon.txt"), "ISO-8859-1"));
        String fstLocation = String.valueOf(path) + "lexicon.fst";
        AlignerTrainer at = new AlignerTrainer(false, true);
        System.out.println("reading lexicon...");
        at.readLexicon(lexReader, "\\\\");
        System.out.println("...done!");
        System.out.println("aligning...");
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < 4) {
            System.out.println(" iteration " + (i + 1));
            at.alignIteration();
            ++i;
        }
        long time = System.currentTimeMillis() - start;
        System.out.println("...done!");
        System.out.println("alignment took " + time + "ms");
        TransducerTrie t = new TransducerTrie();
        System.out.println("entering alignments in trie...");
        int i2 = 0;
        while (i2 < at.lexiconSize()) {
            t.add(at.getAlignment(i2));
            t.add(at.getInfoAlignment(i2));
            ++i2;
        }
        System.out.println("...done!");
        System.out.println("minimizing trie...");
        t.computeMinimization();
        System.out.println("...done!");
        System.out.println("writing transducer to disk...");
        File of = new File(fstLocation);
        DataOutputStream os = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(of)));
        t.writeFST(os, "UTF-8");
        os.flush();
        os.close();
        System.out.println("...done!");
        System.out.println("looking up test words...");
        FSTLookup fst = new FSTLookup(fstLocation);
        System.out.println(" Fahrrad -> " + Arrays.toString(fst.lookup("Fahrrad")));
        System.out.println(" fahren -> " + Arrays.toString(fst.lookup("fahren")));
        System.out.println(" Umwelt -> " + Arrays.toString(fst.lookup("Umwelt")));
        System.out.println(" schonen -> " + Arrays.toString(fst.lookup("schonen")));
        System.out.println(" abgerechnet -> " + Arrays.toString(fst.lookup("abgerechnet")));
        System.out.println(" abgerechnet(A) -> " + Arrays.toString(fst.lookup("abgerechnet(A)")));
        System.out.println(" absorbieren -> " + Arrays.toString(fst.lookup("absorbieren")));
        System.out.println(" absorbieren(WV1b) -> " + Arrays.toString(fst.lookup("absorbieren(WV1b)")));
        System.out.println(" \u00fcbersetzen -> " + Arrays.toString(fst.lookup("\u00fcbersetzen")));
        System.out.println("...done!");
    }
}

