/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import marytts.exceptions.MaryConfigurationException;

public class MaryHeader {
    private static final int MAGIC = 1296126553;
    private static final int VERSION = 40;
    public static final int UNKNOWN = 0;
    public static final int CARTS = 100;
    public static final int DIRECTED_GRAPH = 110;
    public static final int UNITS = 200;
    public static final int LISTENERUNITS = 225;
    public static final int UNITFEATS = 300;
    public static final int LISTENERFEATS = 325;
    public static final int HALFPHONE_UNITFEATS = 301;
    public static final int JOINFEATS = 400;
    public static final int SCOST = 445;
    public static final int PRECOMPUTED_JOINCOSTS = 450;
    public static final int TIMELINE = 500;
    private int magic = 1296126553;
    private int version = 40;
    private int type = 0;

    public static int peekFileType(String fileName) throws IOException {
        DataInputStream dis = null;
        dis = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName)));
        try {
            int type;
            MaryHeader hdr = new MaryHeader(dis);
            int n = type = hdr.getType();
            return n;
        }
        catch (MaryConfigurationException maryConfigurationException) {
            return -1;
        }
        finally {
            dis.close();
        }
    }

    public MaryHeader(int newType) {
        if (newType > 500 || newType < 0) {
            throw new IllegalArgumentException("Unauthorized Mary file type [" + this.type + "].");
        }
        this.type = newType;
        assert (this.version == 40);
        assert (this.hasLegalMagic());
        assert (this.hasLegalType());
    }

    public MaryHeader(DataInput input) throws MaryConfigurationException {
        try {
            this.load(input);
        }
        catch (IOException e) {
            throw new MaryConfigurationException("Cannot load mary header", e);
        }
        if (!this.hasLegalMagic() || !this.hasLegalType()) {
            throw new MaryConfigurationException("Ill-formed Mary header!");
        }
        assert (this.hasLegalMagic());
        assert (this.hasLegalType());
    }

    public MaryHeader(ByteBuffer input) throws MaryConfigurationException {
        try {
            this.load(input);
        }
        catch (BufferUnderflowException e) {
            throw new MaryConfigurationException("Cannot load mary header", e);
        }
        if (!this.hasLegalMagic() || !this.hasLegalType()) {
            throw new MaryConfigurationException("Ill-formed Mary header!");
        }
        assert (this.hasLegalMagic());
        assert (this.hasLegalType());
    }

    public long writeTo(DataOutput output) throws IOException {
        long nBytes = 0L;
        assert (this.hasLegalType()) : "Unknown Mary file type [" + this.type + "].";
        output.writeInt(this.magic);
        nBytes += 4L;
        output.writeInt(this.version);
        nBytes += 4L;
        output.writeInt(this.type);
        return nBytes += 4L;
    }

    private void load(DataInput input) throws IOException {
        this.magic = input.readInt();
        this.version = input.readInt();
        this.type = input.readInt();
    }

    private void load(ByteBuffer input) {
        this.magic = input.getInt();
        this.version = input.getInt();
        this.type = input.getInt();
    }

    public int getMagic() {
        return this.magic;
    }

    public int getVersion() {
        return this.version;
    }

    public int getType() {
        return this.type;
    }

    public boolean hasCurrentVersion() {
        return this.version == 40;
    }

    private boolean hasLegalType() {
        return this.type <= 500 && this.type > 0;
    }

    private boolean hasLegalMagic() {
        return this.magic == 1296126553;
    }
}

