/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.string;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class IntStringTranslator {
    ArrayList<String> list;
    Map<String, Integer> map;

    public IntStringTranslator() {
        this.list = new ArrayList();
        this.map = new HashMap<String, Integer>();
    }

    public IntStringTranslator(int initialRange) {
        this.list = new ArrayList(initialRange);
        this.map = new HashMap<String, Integer>();
    }

    public IntStringTranslator(String[] strings) {
        this.list = new ArrayList<String>(Arrays.asList(strings));
        this.map = new HashMap<String, Integer>();
        int i = 0;
        while (i < strings.length) {
            this.map.put(strings[i], i);
            ++i;
        }
    }

    public void set(int i, String s) {
        this.list.add(i, s);
        this.map.put(s, i);
    }

    public boolean contains(String s) {
        return this.map.containsKey(s);
    }

    public boolean contains(int b) {
        int index = b;
        return index >= 0 && index < this.list.size();
    }

    public int get(String s) {
        Integer index = this.map.get(s);
        if (index == null) {
            throw new IllegalArgumentException("No int value known for string [" + s + "]");
        }
        return index;
    }

    public String get(int i) {
        if (i < 0 || i >= this.list.size()) {
            throw new IndexOutOfBoundsException("Int value out of range: " + i);
        }
        return this.list.get(i);
    }

    public String[] getStringValues() {
        return this.list.toArray(new String[0]);
    }

    public int getHighestValue() {
        return this.list.size();
    }
}

