/**
 * Copyright 2009 DFKI GmbH.
 * All Rights Reserved.  Use is subject to license terms.
 *
 * This file is part of MARY TTS.
 *
 * MARY TTS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/*
 * ProxyPanel.java
 *
 * Created on 22. September 2009, 18:48
 */

package marytts.tools.install;

/**
 * 
 * @author marc
 */
public class ProxyPanel extends javax.swing.JPanel {

	/**
	 * Creates new form ProxyPanel
	 * 
	 * @param host
	 *            host
	 * @param port
	 *            port
	 */
	public ProxyPanel(String host, String port) {
		initComponents();
		if (host != null) {
			tfHost.setText(host);
		}
		if (port != null) {
			tfPort.setText(port);
		}
	}

	public String getProxyHost() {
		return tfHost.getText();
	}

	public String getProxyPort() {
		return tfPort.getText();
	}

	/**
	 * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The content of
	 * this method is always regenerated by the Form Editor.
	 */
	// <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
	private void initComponents() {
		lName = new javax.swing.JLabel();
		lName1 = new javax.swing.JLabel();
		tfHost = new javax.swing.JTextField();
		tfPort = new javax.swing.JTextField();

		setBorder(javax.swing.BorderFactory.createTitledBorder("Enter Proxy information"));
		lName.setFont(new java.awt.Font("Lucida Grande", 1, 13));
		lName.setText("Proxy host");

		lName1.setFont(new java.awt.Font("Lucida Grande", 1, 13));
		lName1.setText("Proxy port");

		org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
		this.setLayout(layout);
		layout.setHorizontalGroup(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING).add(
				layout.createSequentialGroup()
						.addContainerGap()
						.add(layout
								.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
								.add(tfHost, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 229, Short.MAX_VALUE)
								.add(lName)
								.add(lName1)
								.add(tfPort, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 99,
										org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)).addContainerGap()));
		layout.setVerticalGroup(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING).add(
				layout.createSequentialGroup()
						.add(lName)
						.addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
						.add(tfHost, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
								org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
						.add(16, 16, 16)
						.add(lName1)
						.addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
						.add(tfPort, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
								org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
						.addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)));
	}// </editor-fold>//GEN-END:initComponents

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JLabel lName;
	private javax.swing.JLabel lName1;
	private javax.swing.JTextField tfHost;
	private javax.swing.JTextField tfPort;
	// End of variables declaration//GEN-END:variables

}
