/*
 * Decompiled with CFR 0.152.
 */
package marytts.cart;

import java.io.IOException;
import marytts.cart.CART;
import marytts.cart.DecisionNode;
import marytts.cart.LeafNode;
import marytts.cart.impose.FeatureArrayIndexer;
import marytts.cart.impose.MaryNode;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureVector;

public class FeatureVectorCART
extends CART {
    public FeatureVectorCART(MaryNode tree, FeatureArrayIndexer ffi) {
        this.featDef = ffi.getFeatureDefinition();
        this.addDaughters(null, tree, ffi);
        if (this.rootNode instanceof DecisionNode) {
            ((DecisionNode)this.rootNode).countData();
        }
    }

    public void load(String fileName, FeatureDefinition featDefinition, String[] setFeatureSequence) throws IOException {
        throw new IllegalStateException("load() not implemented for FeatureVectorCART");
    }

    private void addDaughters(DecisionNode motherCARTNode, MaryNode currentTreeNode, FeatureArrayIndexer ffi) {
        if (currentTreeNode == null) {
            LeafNode.FeatureVectorLeafNode l = new LeafNode.FeatureVectorLeafNode(new FeatureVector[0]);
            motherCARTNode.addDaughter(l);
            return;
        }
        if (currentTreeNode.isNode()) {
            int numDaughters;
            DecisionNode daughterNode = null;
            int nextFeatIndex = currentTreeNode.getFeatureIndex();
            if (this.featDef.isByteFeature(nextFeatIndex)) {
                numDaughters = this.featDef.getNumberOfValues(nextFeatIndex);
                daughterNode = new DecisionNode.ByteDecisionNode(nextFeatIndex, numDaughters, this.featDef);
            } else if (this.featDef.isShortFeature(nextFeatIndex)) {
                numDaughters = this.featDef.getNumberOfValues(nextFeatIndex);
                daughterNode = new DecisionNode.ShortDecisionNode(nextFeatIndex, numDaughters, this.featDef);
            } else {
                throw new IllegalArgumentException("Found float feature in FeatureFileIndexer!");
            }
            if (motherCARTNode == null) {
                this.rootNode = daughterNode;
                daughterNode.setIsRoot(true);
            } else {
                motherCARTNode.addDaughter(daughterNode);
            }
            int i = 0;
            while (i < numDaughters) {
                MaryNode nextChild = currentTreeNode.getChild(i);
                this.addDaughters(daughterNode, nextChild, ffi);
                ++i;
            }
        } else {
            FeatureVector[] featureVectors = ffi.getFeatureVectors(currentTreeNode.getFrom(), currentTreeNode.getTo());
            LeafNode.FeatureVectorLeafNode leaf = new LeafNode.FeatureVectorLeafNode(featureVectors);
            if (motherCARTNode == null) {
                this.rootNode = leaf;
            } else {
                motherCARTNode.addDaughter(leaf);
            }
        }
    }
}

