/*
 * Decompiled with CFR 0.152.
 */
package marytts.cart;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import marytts.cart.DecisionNode;
import marytts.cart.DirectedGraph;
import marytts.cart.DirectedGraphNode;
import marytts.cart.Node;

public class NodeIterator<T extends Node>
implements Iterator<T> {
    private Node root;
    private Node current;
    private boolean showLeafNodes;
    private boolean showDecisionNodes;
    private boolean showDirectedGraphNodes;
    private Set<Node> alreadySeen = new HashSet<Node>();
    private Map<Node, Node> daughterToMother = new HashMap<Node, Node>();

    protected NodeIterator(DirectedGraph graph, boolean showLeafNodes, boolean showDecisionNodes, boolean showDirectedGraphNodes) {
        this(graph.getRootNode(), showLeafNodes, showDecisionNodes, showDirectedGraphNodes);
    }

    protected NodeIterator(Node rootNode, boolean showLeafNodes, boolean showDecisionNodes, boolean showDirectedGraphNodes) {
        this.root = rootNode;
        this.showLeafNodes = showLeafNodes;
        this.showDecisionNodes = showDecisionNodes;
        this.showDirectedGraphNodes = showDirectedGraphNodes;
        this.current = this.root;
        this.alreadySeen.add(this.current);
        if (!this.currentIsSuitable()) {
            this.nextSuitableNodeDepthFirst();
        }
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public T next() {
        Node ret = this.current;
        this.nextSuitableNodeDepthFirst();
        return (T)ret;
    }

    private boolean currentIsSuitable() {
        return this.current == null || this.showDecisionNodes && this.current.isDecisionNode() || this.showLeafNodes && this.current.isLeafNode() || this.showDirectedGraphNodes && this.current.isDirectedGraphNode();
    }

    private void nextSuitableNodeDepthFirst() {
        do {
            this.nextNodeDepthFirst();
        } while (!this.currentIsSuitable());
    }

    private void nextNodeDepthFirst() {
        if (this.current == null) {
            return;
        }
        if (this.current.isDecisionNode()) {
            DecisionNode dec = (DecisionNode)this.current;
            int i = 0;
            while (i < dec.getNumberOfDaugthers()) {
                Node daughter = dec.getDaughter(i);
                if (daughter != null) {
                    this.daughterToMother.put(daughter, dec);
                    if (this.unseenNode(dec.getDaughter(i))) {
                        return;
                    }
                }
                ++i;
            }
        } else if (this.current.isDirectedGraphNode()) {
            DecisionNode dec;
            DirectedGraphNode g = (DirectedGraphNode)this.current;
            Node leaf = g.getLeafNode();
            if (leaf != null) {
                this.daughterToMother.put(leaf, g);
                if (this.unseenNode(leaf)) {
                    return;
                }
            }
            if ((dec = g.getDecisionNode()) != null) {
                this.daughterToMother.put(dec, g);
                if (this.unseenNode(dec)) {
                    return;
                }
            }
        }
        this.backtrace();
    }

    private void backtrace() {
        this.current = this.daughterToMother.get(this.current);
        this.nextNodeDepthFirst();
    }

    private boolean unseenNode(Node candidate) {
        if (candidate != null && !this.alreadySeen.contains(candidate)) {
            this.current = candidate;
            this.alreadySeen.add(this.current);
            return true;
        }
        return false;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove nodes using this iterator");
    }
}

