/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.effects;

import marytts.signalproc.effects.BaseAudioEffect;
import marytts.util.data.DoubleDataSource;
import marytts.util.math.MathUtils;

public class HMMDurationScaleEffect
extends BaseAudioEffect {
    public float durScale;
    public static float NO_MODIFICATION = 1.0f;
    public static float DEFAULT_DUR_SCALE = 1.5f;
    public static float MAX_DUR_SCALE = 3.0f;
    public static float MIN_DUR_SCALE = 0.1f;

    public HMMDurationScaleEffect() {
        super(16000);
        this.setHMMEffect(true);
        this.setExampleParameters("durScale" + chParamEquals + Float.toString(DEFAULT_DUR_SCALE) + chParamSeparator);
    }

    @Override
    public void parseParameters(String param) {
        super.parseParameters(param);
        this.durScale = this.expectFloatParameter("durScale");
        if (this.durScale == NULL_FLOAT_PARAM) {
            this.durScale = DEFAULT_DUR_SCALE;
        }
        this.durScale = MathUtils.CheckLimits((float)this.durScale, (float)MIN_DUR_SCALE, (float)MAX_DUR_SCALE);
    }

    @Override
    public DoubleDataSource process(DoubleDataSource input) {
        return input;
    }

    @Override
    public String getHelpText() {
        String strHelp = "Duration scaling for HMM voices:" + strLineBreak + "Scales the HMM output speech duration by <durScale>." + strLineBreak + "Parameter:" + strLineBreak + "   <durScale>" + "   Definition : Duration scaling factor for synthesized speech output" + strLineBreak + "   Range      : [" + String.valueOf(MIN_DUR_SCALE) + "," + String.valueOf(MAX_DUR_SCALE) + "]" + strLineBreak + "Example:" + strLineBreak + this.getExampleParameters();
        return strHelp;
    }

    @Override
    public String getName() {
        return "Rate";
    }
}

