/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.concat;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sound.sampled.AudioInputStream;
import marytts.modules.phonemiser.Allophone;
import marytts.server.MaryProperties;
import marytts.signalproc.process.FDPSOLAProcessor;
import marytts.unitselection.analysis.Phone;
import marytts.unitselection.concat.BaseUnitConcatenator;
import marytts.unitselection.concat.OverlapUnitConcatenator;
import marytts.unitselection.select.SelectedUnit;
import marytts.unitselection.select.Target;
import marytts.util.data.Datagram;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.math.MathUtils;

public class FdpsolaUnitConcatenator
extends OverlapUnitConcatenator {
    private double minTimeScaleFactor = 0.5;
    private double maxTimeScaleFactor = 2.0;
    private double minPitchScaleFactor = 0.5;
    private double maxPitchScaleFactor = 2.0;

    public FdpsolaUnitConcatenator() {
    }

    public FdpsolaUnitConcatenator(double minTimeScaleFactor, double maxTimeScaleFactor, double minPitchScaleFactor, double maxPitchScaleFactor) {
        this.minTimeScaleFactor = minTimeScaleFactor;
        this.maxTimeScaleFactor = maxTimeScaleFactor;
        this.minPitchScaleFactor = minPitchScaleFactor;
        this.maxPitchScaleFactor = maxPitchScaleFactor;
    }

    private Datagram[][] getDatagrams(List<SelectedUnit> units) {
        Datagram[][] datagrams = new Datagram[units.size()][];
        int i = 0;
        while (i < units.size()) {
            BaseUnitConcatenator.UnitData unitData = (BaseUnitConcatenator.UnitData)units.get(i).getConcatenationData();
            datagrams[i] = unitData.getFrames();
            ++i;
        }
        return datagrams;
    }

    private Datagram[] getRightContexts(List<SelectedUnit> units) {
        Datagram[] rightContexts = new Datagram[units.size()];
        int i = 0;
        while (i < rightContexts.length) {
            SelectedUnit unit = units.get(i);
            BaseUnitConcatenator.UnitData unitData = (BaseUnitConcatenator.UnitData)unit.getConcatenationData();
            rightContexts[i] = unitData.getRightContextFrame();
            ++i;
        }
        return rightContexts;
    }

    private boolean[][] getVoicings(List<SelectedUnit> units) {
        Datagram[][] datagrams = this.getDatagrams(units);
        boolean[][] voicings = new boolean[datagrams.length][];
        int i = 0;
        while (i < datagrams.length) {
            Allophone allophone = units.get(i).getTarget().getAllophone();
            voicings[i] = new boolean[datagrams[i].length];
            if (allophone != null && allophone.isVoiced()) {
                Arrays.fill(voicings[i], true);
            } else {
                Arrays.fill(voicings[i], false);
            }
            ++i;
        }
        return voicings;
    }

    private double[][] getPitchScales(List<SelectedUnit> units) {
        Datagram[][] datagrams = this.getDatagrams(units);
        int len = datagrams.length;
        double[][] pscales = new double[len][];
        SelectedUnit prevUnit = null;
        SelectedUnit unit = null;
        SelectedUnit nextUnit = null;
        Target prevTarget = null;
        Target target = null;
        Target nextTarget = null;
        int i = 0;
        while (i < len) {
            int j;
            prevUnit = i > 0 ? units.get(i - 1) : null;
            unit = units.get(i);
            nextUnit = i < len - 1 ? units.get(i + 1) : null;
            if (prevUnit != null) {
                prevTarget = prevUnit.getTarget();
            }
            target = unit.getTarget();
            if (nextUnit != null) {
                nextTarget = nextUnit.getTarget();
            }
            Allophone allophone = unit.getTarget().getAllophone();
            int totalDatagrams = 0;
            int totalTargetUnits = 0;
            if (i > 0 && prevTarget != null && !prevTarget.isSilence()) {
                j = 0;
                while (j < datagrams[i - 1].length) {
                    if (allophone != null && (allophone.isVowel() || allophone.isVoiced())) {
                        this.timeline.getSampleRate();
                        datagrams[i - 1][j].getDuration();
                        ++totalDatagrams;
                    }
                    ++j;
                }
                prevTarget.getTargetF0InHz();
                ++totalTargetUnits;
            }
            if (target != null && !target.isSilence()) {
                j = 0;
                while (j < datagrams[i].length) {
                    if (allophone != null && (allophone.isVowel() || allophone.isVoiced())) {
                        this.timeline.getSampleRate();
                        datagrams[i][j].getDuration();
                        ++totalDatagrams;
                    }
                    target.getTargetF0InHz();
                    ++totalTargetUnits;
                    ++j;
                }
            }
            if (i < len - 1 && prevTarget != null && !prevTarget.isSilence()) {
                j = 0;
                while (j < datagrams[i + 1].length) {
                    if (allophone != null && (allophone.isVowel() || allophone.isVoiced())) {
                        this.timeline.getSampleRate();
                        datagrams[i + 1][j].getDuration();
                        ++totalDatagrams;
                    }
                    ++j;
                }
                nextTarget.getTargetF0InHz();
                ++totalTargetUnits;
            }
            pscales[i] = new double[datagrams[i].length];
            j = 0;
            while (j < datagrams[i].length) {
                pscales[i][j] = allophone != null && allophone.isVoiced() ? 1.0 : 1.0;
                ++j;
            }
            ++i;
        }
        return pscales;
    }

    private double[][] getDurationScales(List<SelectedUnit> units) {
        int j;
        Datagram[][] datagrams = this.getDatagrams(units);
        int len = datagrams.length;
        double[][] tscales = new double[len][];
        double[] unitDurationsInSeconds = new double[datagrams.length];
        SelectedUnit unit = null;
        int i = 0;
        while (i < len) {
            int unitDuration = 0;
            j = 0;
            while (j < datagrams[i].length) {
                unitDuration = j == datagrams[i].length - 1 ? (int)((long)unitDuration + datagrams[i][j].getDuration()) : (int)((long)unitDuration + datagrams[i][j].getDuration());
                ++j;
            }
            unitDurationsInSeconds[i] = (double)unitDuration / (double)this.timeline.getSampleRate();
            ++i;
        }
        i = 0;
        while (i < len) {
            double targetDur = 0.0;
            double unitDur = 0.0;
            unit = units.get(i);
            targetDur += (double)unit.getTarget().getTargetDurationInSeconds();
            unitDur += unitDurationsInSeconds[i];
            tscales[i] = new double[datagrams[i].length];
            j = 0;
            while (j < datagrams[i].length) {
                tscales[i][j] = targetDur / unitDur;
                ++j;
            }
            this.logger.debug((Object)("time scaling factor for unit " + unit.getTarget().getName() + " -> " + targetDur / unitDur));
            ++i;
        }
        return tscales;
    }

    private double[][] getPhoneBasedDurationScales(List<SelectedUnit> units) {
        List<Double> timeScaleFactors = this.prosodyAnalyzer.getDurationFactors();
        double[][] tscales = new double[timeScaleFactors.size()][];
        Datagram[][] datagrams = this.getDatagrams(units);
        int i = 0;
        while (i < tscales.length) {
            tscales[i] = new double[datagrams[i].length];
            Arrays.fill(tscales[i], timeScaleFactors.get(i));
            ++i;
        }
        try {
            this.prosodyAnalyzer.writePraatDurationTier(String.valueOf(MaryProperties.maryBase()) + "/tscales.DurationTier");
        }
        catch (IOException iOException) {
            this.logger.warn((Object)"Could not dump tscales to file");
        }
        return tscales;
    }

    @Deprecated
    private List<SelectedUnit> getNonEmptyUnits(List<SelectedUnit> units) {
        ArrayList<SelectedUnit> nonEmptyUnits = new ArrayList<SelectedUnit>(units.size());
        for (SelectedUnit unit : units) {
            BaseUnitConcatenator.UnitData unitData = (BaseUnitConcatenator.UnitData)unit.getConcatenationData();
            if (unitData.getUnitDuration() <= 0 || unit.getTarget().getMaryxmlElement() == null) continue;
            nonEmptyUnits.add(unit);
        }
        return nonEmptyUnits;
    }

    protected Datagram[][] getRealizedDatagrams(List<Phone> phones) {
        ArrayList<Datagram[]> datagramList = new ArrayList<Datagram[]>();
        for (Phone phone : phones) {
            if (phone.getLeftTargetDuration() > 0.0) {
                Datagram[] leftDatagrams = phone.getLeftUnitFrames();
                datagramList.add(leftDatagrams);
            }
            if (!(phone.getRightTargetDuration() > 0.0)) continue;
            Datagram[] rightDatagrams = phone.getRightUnitFrames();
            datagramList.add(rightDatagrams);
        }
        Datagram[][] datagramArray = (Datagram[][])datagramList.toArray((T[])new Datagram[datagramList.size()][]);
        return datagramArray;
    }

    protected Datagram[] getRealizedRightContexts(List<Phone> phones) {
        ArrayList<Datagram> datagramList = new ArrayList<Datagram>();
        for (Phone phone : phones) {
            if (phone.getLeftTargetDuration() > 0.0) {
                BaseUnitConcatenator.UnitData leftUnitData = phone.getLeftUnitData();
                Datagram leftRightContext = leftUnitData.getRightContextFrame();
                datagramList.add(leftRightContext);
            }
            if (!(phone.getRightTargetDuration() > 0.0)) continue;
            BaseUnitConcatenator.UnitData rightUnitData = phone.getRightUnitData();
            Datagram rightRightContext = rightUnitData.getRightContextFrame();
            datagramList.add(rightRightContext);
        }
        Datagram[] datagramArray = datagramList.toArray(new Datagram[datagramList.size()]);
        return datagramArray;
    }

    private boolean[][] getRealizedVoicings(List<Phone> phones) {
        ArrayList<boolean[]> voicingList = new ArrayList<boolean[]>();
        for (Phone phone : phones) {
            boolean voiced = phone.isVoiced();
            if (phone.getLeftTargetDuration() > 0.0) {
                int leftNumberOfFrames = phone.getNumberOfLeftUnitFrames();
                boolean[] leftVoiceds = new boolean[leftNumberOfFrames];
                Arrays.fill(leftVoiceds, voiced);
                voicingList.add(leftVoiceds);
            }
            if (!(phone.getRightTargetDuration() > 0.0)) continue;
            int rightNumberOfFrames = phone.getNumberOfRightUnitFrames();
            boolean[] rightVoiceds = new boolean[rightNumberOfFrames];
            Arrays.fill(rightVoiceds, voiced);
            voicingList.add(rightVoiceds);
        }
        boolean[][] voicingArray = (boolean[][])voicingList.toArray((T[])new boolean[voicingList.size()][]);
        return voicingArray;
    }

    private double[][] getRealizedTimeScales(List<Phone> phones) {
        ArrayList<double[]> durationFactorList = new ArrayList<double[]>(phones.size());
        for (Phone phone : phones) {
            String message;
            if (phone.getLeftTargetDuration() > 0.0) {
                int leftNumberOfFrames = phone.getNumberOfLeftUnitFrames();
                double leftDurationFactor = phone.getLeftDurationFactor();
                if (leftDurationFactor < this.minTimeScaleFactor) {
                    message = "Left duration factor (" + leftDurationFactor + ") for phone " + phone + " too small;";
                    leftDurationFactor = this.minTimeScaleFactor;
                    message = String.valueOf(message) + " clipped to " + leftDurationFactor;
                    this.logger.debug((Object)message);
                } else if (leftDurationFactor > this.maxTimeScaleFactor) {
                    message = "Left duration factor (" + leftDurationFactor + ") for phone " + phone + " too large;";
                    leftDurationFactor = this.maxTimeScaleFactor;
                    message = String.valueOf(message) + " clipped to " + leftDurationFactor;
                    this.logger.debug((Object)message);
                }
                double[] leftDurationFactors = new double[leftNumberOfFrames];
                Arrays.fill(leftDurationFactors, leftDurationFactor);
                durationFactorList.add(leftDurationFactors);
            }
            if (!(phone.getRightTargetDuration() > 0.0)) continue;
            int rightNumberOfFrames = phone.getNumberOfRightUnitFrames();
            double rightDurationFactor = phone.getRightDurationFactor();
            if (phone.isTransient()) {
                rightDurationFactor = 1.0;
            }
            if (rightDurationFactor < this.minTimeScaleFactor) {
                message = "Right duration factor (" + rightDurationFactor + ") for phone " + phone + " too small;";
                rightDurationFactor = this.minTimeScaleFactor;
                message = String.valueOf(message) + " clipped to " + rightDurationFactor;
                this.logger.debug((Object)message);
            } else if (rightDurationFactor > this.maxTimeScaleFactor) {
                message = "Right duration factor (" + rightDurationFactor + ") for phone " + phone + " too large;";
                rightDurationFactor = this.maxTimeScaleFactor;
                message = String.valueOf(message) + " clipped to " + rightDurationFactor;
                this.logger.debug((Object)message);
            }
            double[] rightDurationFactors = new double[rightNumberOfFrames];
            Arrays.fill(rightDurationFactors, rightDurationFactor);
            durationFactorList.add(rightDurationFactors);
        }
        double[][] durationFactorArray = (double[][])durationFactorList.toArray((T[])new double[durationFactorList.size()][]);
        return durationFactorArray;
    }

    private double[][] getRealizedPitchScales(List<Phone> phones) {
        ArrayList<double[]> f0FactorList = new ArrayList<double[]>(phones.size());
        for (Phone phone : phones) {
            boolean clipped;
            if (phone.getLeftTargetDuration() > 0.0) {
                phone.getNumberOfLeftUnitFrames();
                double[] leftF0Factors = phone.getLeftF0Factors();
                clipped = MathUtils.clipRange((double[])leftF0Factors, (double)this.minPitchScaleFactor, (double)this.maxPitchScaleFactor);
                if (clipped) {
                    this.logger.debug((Object)("Left F0 factors for phone " + phone + " contained out-of-range values; clipped to [" + this.minPitchScaleFactor + ", " + this.maxPitchScaleFactor + "]"));
                }
                f0FactorList.add(leftF0Factors);
            }
            if (!(phone.getRightTargetDuration() > 0.0)) continue;
            phone.getNumberOfRightUnitFrames();
            double[] rightF0Factors = phone.getRightF0Factors();
            clipped = MathUtils.clipRange((double[])rightF0Factors, (double)this.minPitchScaleFactor, (double)this.maxPitchScaleFactor);
            if (clipped) {
                this.logger.debug((Object)("Left F0 factors for phone " + phone + " contained out-of-range values; clipped to [" + this.minPitchScaleFactor + ", " + this.maxPitchScaleFactor + "]"));
            }
            f0FactorList.add(rightF0Factors);
        }
        double[][] f0FactorArray = (double[][])f0FactorList.toArray((T[])new double[f0FactorList.size()][]);
        return f0FactorArray;
    }

    @Override
    protected AudioInputStream generateAudioStream(List<SelectedUnit> units) throws IOException {
        List<Phone> realizedPhones = this.prosodyAnalyzer.getRealizedPhones();
        Datagram[][] datagrams = this.getRealizedDatagrams(realizedPhones);
        Datagram[] rightContexts = this.getRealizedRightContexts(realizedPhones);
        boolean[][] voicings = this.getRealizedVoicings(realizedPhones);
        double[][] tscales = this.getRealizedTimeScales(realizedPhones);
        double[][] pscales = this.getRealizedPitchScales(realizedPhones);
        DDSAudioInputStream stream = new FDPSOLAProcessor().processDecrufted(datagrams, rightContexts, this.audioformat, voicings, pscales, tscales);
        this.updateRealizedUnitDataDurations(realizedPhones, datagrams);
        return stream;
    }

    private void updateUnitDataDurations(List<SelectedUnit> units, Datagram[][] datagrams) {
        int i = 0;
        while (i < datagrams.length) {
            SelectedUnit unit = units.get(i);
            BaseUnitConcatenator.UnitData unitData = (BaseUnitConcatenator.UnitData)unit.getConcatenationData();
            int unitDuration = 0;
            int j = 0;
            while (j < datagrams[i].length) {
                int datagramDuration = (int)datagrams[i][j].getDuration();
                unitData.getFrame(j).setDuration((long)datagramDuration);
                unitDuration += datagramDuration;
                ++j;
            }
            unitData.setUnitDuration(unitDuration);
            ++i;
        }
    }

    private void updateRealizedUnitDataDurations(List<Phone> phones, Datagram[][] datagrams) {
        int phIndex = 0;
        for (Phone phone : phones) {
            int datagramDuration;
            int dg;
            if (phone.getLeftTargetDuration() > 0.0) {
                BaseUnitConcatenator.UnitData leftUnitData = phone.getLeftUnitData();
                int leftUnitDataDuration = 0;
                dg = 0;
                while (dg < datagrams[phIndex].length) {
                    datagramDuration = (int)datagrams[phIndex][dg].getDuration();
                    leftUnitData.getFrame(dg).setDuration((long)datagramDuration);
                    leftUnitDataDuration += datagramDuration;
                    ++dg;
                }
                ++phIndex;
                leftUnitData.setUnitDuration(leftUnitDataDuration);
            }
            if (!(phone.getRightTargetDuration() > 0.0)) continue;
            BaseUnitConcatenator.UnitData rightUnitData = phone.getRightUnitData();
            int rightUnitDataDuration = 0;
            dg = 0;
            while (dg < datagrams[phIndex].length) {
                datagramDuration = (int)datagrams[phIndex][dg].getDuration();
                rightUnitData.getFrame(dg).setDuration((long)datagramDuration);
                rightUnitDataDuration += datagramDuration;
                ++dg;
            }
            ++phIndex;
            rightUnitData.setUnitDuration(rightUnitDataDuration);
        }
    }
}

