/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.concat;

import java.io.IOException;
import java.util.List;
import javax.sound.sampled.AudioInputStream;
import marytts.unitselection.concat.BaseUnitConcatenator;
import marytts.unitselection.concat.DatagramOverlapDoubleDataSource;
import marytts.unitselection.data.Unit;
import marytts.unitselection.select.SelectedUnit;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.Datagram;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;

public class OverlapUnitConcatenator
extends BaseUnitConcatenator {
    @Override
    protected void getDatagramsFromTimeline(List<SelectedUnit> units) throws IOException {
        for (SelectedUnit unit : units) {
            assert (!unit.getUnit().isEdgeUnit()) : "We should never have selected any edge units!";
            OverlapUnitData unitData = new OverlapUnitData();
            unit.setConcatenationData(unitData);
            int unitSize = this.unitToTimeline(unit.getUnit().duration);
            long unitStart = this.unitToTimeline(unit.getUnit().startTime);
            Datagram[] datagrams = this.timeline.getDatagrams(unitStart, (long)unitSize);
            unitData.setFrames(datagrams);
            Datagram rightContextFrame = null;
            Unit nextInDB = this.database.getUnitFileReader().getNextUnit(unit.getUnit());
            if (nextInDB == null || nextInDB.isEdgeUnit()) continue;
            rightContextFrame = this.timeline.getDatagram(unitStart + (long)unitSize);
            unitData.setRightContextFrame(rightContextFrame);
        }
    }

    @Override
    protected void determineTargetPitchmarks(List<SelectedUnit> units) {
        for (SelectedUnit unit : units) {
            BaseUnitConcatenator.UnitData unitData = (BaseUnitConcatenator.UnitData)unit.getConcatenationData();
            assert (unitData != null) : "Should not have null unitdata here";
            Datagram[] datagrams = unitData.getFrames();
            Datagram[] frames = null;
            int unitDuration = 0;
            int nZeroLengthDatagrams = 0;
            int i = 0;
            while (i < datagrams.length) {
                int dur = (int)datagrams[i].getDuration();
                if (dur == 0) {
                    ++nZeroLengthDatagrams;
                }
                unitDuration = (int)((long)unitDuration + datagrams[i].getDuration());
                ++i;
            }
            if (nZeroLengthDatagrams > 0) {
                this.logger.warn((Object)("Unit " + unit + " contains " + nZeroLengthDatagrams + " zero-length datagrams -- removing them"));
                Datagram[] dummy = new Datagram[datagrams.length - nZeroLengthDatagrams];
                int i2 = 0;
                int j = 0;
                while (i2 < datagrams.length) {
                    if (datagrams[i2].getDuration() > 0L) {
                        dummy[j++] = datagrams[i2];
                    }
                    ++i2;
                }
                datagrams = dummy;
                unitData.setFrames(datagrams);
            }
            if (unit.getTarget().isSilence()) {
                int targetDuration = Math.round(unit.getTarget().getTargetDurationInSeconds() * this.audioformat.getSampleRate());
                if (targetDuration > 0 && datagrams != null && datagrams.length > 0) {
                    int firstPeriodDur = (int)datagrams[0].getDuration();
                    if (targetDuration < firstPeriodDur) {
                        this.logger.debug((Object)("For " + unit + ", adjusting target duration to be at least one period: " + (float)firstPeriodDur / this.audioformat.getSampleRate() + " s instead of requested " + unit.getTarget().getTargetDurationInSeconds() + " s"));
                        targetDuration = firstPeriodDur;
                    }
                    if (unitDuration < targetDuration) {
                        frames = new Datagram[datagrams.length + 1];
                        int mid = (datagrams.length + 1) / 2;
                        System.arraycopy(datagrams, 0, frames, 0, mid);
                        if (mid < datagrams.length) {
                            System.arraycopy(datagrams, mid, frames, mid + 1, datagrams.length - mid);
                        }
                        frames[mid] = this.createZeroDatagram(targetDuration - unitDuration);
                    } else {
                        int midright = (datagrams.length + 1) / 2;
                        int midleft = midright - 1;
                        while (unitDuration > targetDuration && midright < datagrams.length) {
                            unitDuration = (int)((long)unitDuration - datagrams[midright].getDuration());
                            ++midright;
                            if (unitDuration <= targetDuration || midleft <= 0) continue;
                            unitDuration = (int)((long)unitDuration - datagrams[midleft].getDuration());
                            --midleft;
                        }
                        frames = new Datagram[midleft + 1 + datagrams.length - midright];
                        assert (midleft >= 0);
                        System.arraycopy(datagrams, 0, frames, 0, midleft + 1);
                        if (midright < datagrams.length) {
                            System.arraycopy(datagrams, midright, frames, midleft + 1, datagrams.length - midright);
                        }
                    }
                    unitDuration = targetDuration;
                } else {
                    frames = new Datagram[]{this.createZeroDatagram(targetDuration)};
                    unitDuration = targetDuration;
                }
            } else {
                frames = datagrams;
            }
            unitData.setUnitDuration(unitDuration);
            unitData.setFrames(frames);
        }
    }

    @Override
    protected AudioInputStream generateAudioStream(List<SelectedUnit> units) throws IOException {
        int len = units.size();
        Datagram[][] datagrams = new Datagram[len][];
        Datagram[] rightContexts = new Datagram[len];
        int i = 0;
        while (i < len) {
            SelectedUnit unit = units.get(i);
            OverlapUnitData unitData = (OverlapUnitData)unit.getConcatenationData();
            assert (unitData != null) : "Should not have null unitdata here";
            Datagram[] frames = unitData.getFrames();
            assert (frames != null) : "Cannot generate audio from null frames";
            datagrams[i] = frames;
            Unit nextInDB = this.database.getUnitFileReader().getNextUnit(unit.getUnit());
            Unit nextSelected = i + 1 == len ? null : units.get(i + 1).getUnit();
            if (nextInDB != null && !nextInDB.equals(nextSelected)) {
                rightContexts[i] = unitData.getRightContextFrame();
            }
            ++i;
        }
        DatagramOverlapDoubleDataSource audioSource = new DatagramOverlapDoubleDataSource(datagrams, rightContexts);
        return new DDSAudioInputStream((DoubleDataSource)new BufferedDoubleDataSource((DoubleDataSource)audioSource), this.audioformat);
    }

    public static class OverlapUnitData
    extends BaseUnitConcatenator.UnitData {
        protected Datagram rightContextFrame;

        @Override
        public void setRightContextFrame(Datagram aRightContextFrame) {
            this.rightContextFrame = aRightContextFrame;
        }

        @Override
        public Datagram getRightContextFrame() {
            return this.rightContextFrame;
        }
    }
}

