/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import marytts.cart.CART;
import marytts.unitselection.data.TimelineReader;
import marytts.unitselection.data.Unit;
import marytts.unitselection.data.UnitFileReader;
import marytts.unitselection.select.JoinCostFunction;
import marytts.unitselection.select.StatisticalCostFunction;
import marytts.unitselection.select.Target;
import marytts.unitselection.select.TargetCostFunction;
import marytts.unitselection.select.viterbi.ViterbiCandidate;
import marytts.util.MaryUtils;
import marytts.util.data.Datagram;
import marytts.util.dom.DomUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UnitDatabase {
    protected TargetCostFunction targetCostFunction;
    protected JoinCostFunction joinCostFunction;
    protected StatisticalCostFunction sCostFunction = null;
    protected UnitFileReader unitReader;
    protected int numUnits;
    protected CART preselectionCART;
    protected TimelineReader audioTimeline;
    protected TimelineReader basenameTimeline;
    protected int backtrace;
    protected Logger logger = MaryUtils.getLogger((String)"UnitDatabase");

    public void load(TargetCostFunction aTargetCostFunction, JoinCostFunction aJoinCostFunction, UnitFileReader aUnitReader, CART aPreselectionCART, TimelineReader anAudioTimeline, TimelineReader aBasenameTimeline, int backtraceLeafSize) {
        this.targetCostFunction = aTargetCostFunction;
        this.joinCostFunction = aJoinCostFunction;
        this.unitReader = aUnitReader;
        this.numUnits = this.unitReader != null ? this.unitReader.getNumberOfUnits() : 0;
        this.preselectionCART = aPreselectionCART;
        this.audioTimeline = anAudioTimeline;
        this.basenameTimeline = aBasenameTimeline;
        this.backtrace = backtraceLeafSize;
    }

    public void load(TargetCostFunction aTargetCostFunction, JoinCostFunction aJoinCostFunction, StatisticalCostFunction asCostFunction, UnitFileReader aUnitReader, CART aPreselectionCART, TimelineReader anAudioTimeline, TimelineReader aBasenameTimeline, int backtraceLeafSize) {
        this.targetCostFunction = aTargetCostFunction;
        this.joinCostFunction = aJoinCostFunction;
        this.sCostFunction = asCostFunction;
        this.unitReader = aUnitReader;
        this.numUnits = this.unitReader != null ? this.unitReader.getNumberOfUnits() : 0;
        this.preselectionCART = aPreselectionCART;
        this.audioTimeline = anAudioTimeline;
        this.basenameTimeline = aBasenameTimeline;
        this.backtrace = backtraceLeafSize;
    }

    public TargetCostFunction getTargetCostFunction() {
        return this.targetCostFunction;
    }

    public JoinCostFunction getJoinCostFunction() {
        return this.joinCostFunction;
    }

    public UnitFileReader getUnitFileReader() {
        return this.unitReader;
    }

    public TimelineReader getAudioTimeline() {
        return this.audioTimeline;
    }

    public StatisticalCostFunction getSCostFunction() {
        return this.sCostFunction;
    }

    public List<ViterbiCandidate> getCandidates(Target target) {
        String blacklist = "";
        String unitBasename = "This must never be null or the empty string!";
        Element targetElement = target.getMaryxmlElement();
        blacklist = DomUtils.getAttributeFromClosestAncestorOfAnyKind((Node)targetElement, (String)"blacklist");
        int[] clist = (int[])this.preselectionCART.interpret(target, this.backtrace);
        this.logger.debug((Object)("For target " + target + ", selected " + clist.length + " units"));
        ArrayList<ViterbiCandidate> candidates = new ArrayList<ViterbiCandidate>();
        int i = 0;
        while (i < clist.length) {
            Unit unit = this.unitReader.getUnit(clist[i]);
            candidates.add(new ViterbiCandidate(target, unit, this.targetCostFunction));
            ++i;
        }
        Iterator candIt = candidates.iterator();
        while (candIt.hasNext()) {
            ViterbiCandidate candidate = (ViterbiCandidate)candIt.next();
            unitBasename = this.getFilename(candidate.getUnit());
            if (!blacklist.contains(unitBasename)) continue;
            candIt.remove();
        }
        return candidates;
    }

    public String getFilenameAndTime(Unit unit) {
        if (this.basenameTimeline == null) {
            return "unknown origin";
        }
        long[] offset = new long[1];
        try {
            Datagram[] datagrams = this.basenameTimeline.getDatagrams(unit.startTime, 1, this.unitReader.getSampleRate(), offset);
            Datagram filenameData = datagrams[0];
            float time = (float)offset[0] / (float)this.basenameTimeline.getSampleRate();
            String filename = new String(filenameData.getData(), "UTF-8");
            return String.valueOf(filename) + " " + time;
        }
        catch (Exception e) {
            this.logger.warn((Object)("Problem getting filename and time for unit " + unit.index + " at time " + unit.startTime), (Throwable)e);
            return "unknown origin";
        }
    }

    public String getFilename(Unit unit) {
        try {
            Datagram filenameData = this.basenameTimeline.getDatagram(unit.startTime);
            String filename = new String(filenameData.getData(), "UTF-8");
            return filename;
        }
        catch (Exception e) {
            this.logger.warn((Object)("Problem getting filename for unit " + unit.index), (Throwable)e);
            return "unknown origin";
        }
    }
}

