/*
 * Decompiled with CFR 0.152.
 */
package marytts.vocalizations;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import marytts.exceptions.MaryConfigurationException;
import marytts.exceptions.SynthesisException;
import marytts.signalproc.process.FDPSOLAProcessor;
import marytts.unitselection.data.TimelineReader;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.Datagram;
import marytts.util.data.DatagramDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.math.MathUtils;
import marytts.util.math.Polynomial;
import marytts.vocalizations.HNMFeatureFileReader;
import marytts.vocalizations.VocalizationIntonationReader;
import marytts.vocalizations.VocalizationSynthesisTechnology;
import marytts.vocalizations.VocalizationUnit;
import marytts.vocalizations.VocalizationUnitFileReader;

public class FDPSOLASynthesisTechnology
extends VocalizationSynthesisTechnology {
    protected VocalizationIntonationReader vIntonationReader;
    protected TimelineReader audioTimeline;
    protected VocalizationUnitFileReader unitFileReader;
    protected boolean f0ContourImposeSupport;

    public FDPSOLASynthesisTechnology(String waveTimeLineFile, String unitFile, String intonationFeatureFile, boolean imposeF0Support) throws MaryConfigurationException {
        try {
            this.audioTimeline = new TimelineReader(waveTimeLineFile);
            this.unitFileReader = new VocalizationUnitFileReader(unitFile);
            this.f0ContourImposeSupport = imposeF0Support;
            this.vIntonationReader = this.f0ContourImposeSupport ? new VocalizationIntonationReader(intonationFeatureFile) : null;
        }
        catch (IOException e) {
            throw new MaryConfigurationException("Can not read data from files " + e);
        }
    }

    public FDPSOLASynthesisTechnology(TimelineReader audioTimeline, VocalizationUnitFileReader unitFileReader, HNMFeatureFileReader vHNMFeaturesReader, VocalizationIntonationReader vIntonationReader, boolean imposeF0Support) {
        this.audioTimeline = audioTimeline;
        this.unitFileReader = unitFileReader;
        this.vIntonationReader = vIntonationReader;
        this.f0ContourImposeSupport = imposeF0Support;
    }

    @Override
    public AudioInputStream synthesize(int backchannelNumber, AudioFileFormat aft) throws SynthesisException {
        int numberOfBackChannels = this.unitFileReader.getNumberOfUnits();
        if (backchannelNumber >= numberOfBackChannels) {
            throw new IllegalArgumentException("This voice has " + numberOfBackChannels + " backchannels only. so it doesn't support unit number " + backchannelNumber);
        }
        VocalizationUnit bUnit = this.unitFileReader.getUnit(backchannelNumber);
        long start = bUnit.startTime;
        int duration = bUnit.duration;
        Datagram[] frames = null;
        try {
            frames = this.audioTimeline.getDatagrams(start, (long)duration);
        }
        catch (IOException e) {
            throw new SynthesisException("Can not read data from timeline file " + e);
        }
        LinkedList<Datagram> datagrams = new LinkedList<Datagram>();
        datagrams.addAll(Arrays.asList(frames));
        DatagramDoubleDataSource audioSource = new DatagramDoubleDataSource(datagrams);
        return new DDSAudioInputStream((DoubleDataSource)new BufferedDoubleDataSource((DoubleDataSource)audioSource), aft.getFormat());
    }

    @Override
    public AudioInputStream reSynthesize(int backchannelNumber, AudioFileFormat aft) throws SynthesisException {
        double[] pScalesArray = new double[]{1.0};
        double[] tScalesArray = new double[]{1.0};
        return this.synthesizeUsingF0Modification(backchannelNumber, pScalesArray, tScalesArray, aft);
    }

    @Override
    public AudioInputStream synthesizeUsingImposedF0(int sourceIndex, int targetIndex, AudioFileFormat aft) throws SynthesisException {
        if (!this.f0ContourImposeSupport) {
            throw new SynthesisException("Mary configuration of this voice doesn't support intonation contour imposition");
        }
        int numberOfUnits = this.unitFileReader.getNumberOfUnits();
        if (sourceIndex >= numberOfUnits || targetIndex >= numberOfUnits) {
            throw new IllegalArgumentException("sourceIndex(" + sourceIndex + ") and targetIndex(" + targetIndex + ") are should be less than number of available units (" + numberOfUnits + ")");
        }
        if (sourceIndex == targetIndex) {
            return this.reSynthesize(sourceIndex, aft);
        }
        double[] sourceF0 = this.vIntonationReader.getContour(sourceIndex);
        double[] targetF0coeffs = this.vIntonationReader.getIntonationCoeffs(targetIndex);
        double[] sourceF0coeffs = this.vIntonationReader.getIntonationCoeffs(sourceIndex);
        if (targetF0coeffs == null || sourceF0coeffs == null) {
            return this.reSynthesize(sourceIndex, aft);
        }
        if (targetF0coeffs.length == 0 || sourceF0coeffs.length == 0) {
            return this.reSynthesize(sourceIndex, aft);
        }
        double[] targetF0 = Polynomial.generatePolynomialValues((double[])targetF0coeffs, (int)sourceF0.length, (double)0.0, (double)1.0);
        sourceF0 = Polynomial.generatePolynomialValues((double[])sourceF0coeffs, (int)sourceF0.length, (double)0.0, (double)1.0);
        assert (targetF0.length == sourceF0.length);
        double[] tScalesArray = new double[sourceF0.length];
        double[] pScalesArray = new double[sourceF0.length];
        int i = 0;
        while (i < targetF0.length) {
            pScalesArray[i] = (float)(targetF0[i] / sourceF0[i]);
            tScalesArray[i] = 1.0;
            ++i;
        }
        return this.synthesizeUsingF0Modification(sourceIndex, pScalesArray, tScalesArray, aft);
    }

    private AudioInputStream synthesizeUsingF0Modification(int backchannelNumber, double[] pScalesArray, double[] tScalesArray, AudioFileFormat aft) throws SynthesisException {
        AudioFormat af;
        if (backchannelNumber > this.unitFileReader.getNumberOfUnits()) {
            throw new IllegalArgumentException("requesting unit should not be more than number of units");
        }
        if (!this.f0ContourImposeSupport) {
            throw new SynthesisException("Mary configuration of this voice doesn't support intonation contour imposition");
        }
        VocalizationUnit bUnit = this.unitFileReader.getUnit(backchannelNumber);
        long start = bUnit.startTime;
        int duration = bUnit.duration;
        Datagram[] frames = null;
        try {
            frames = this.audioTimeline.getDatagrams(start, (long)duration);
        }
        catch (IOException e) {
            throw new SynthesisException("cannot get audio frames from timeline file " + e);
        }
        assert (frames != null) : "Cannot generate audio from null frames";
        pScalesArray = MathUtils.arrayResize((double[])pScalesArray, (int)frames.length);
        tScalesArray = MathUtils.arrayResize((double[])tScalesArray, (int)frames.length);
        assert (tScalesArray.length == pScalesArray.length);
        assert (frames.length == tScalesArray.length);
        if (aft == null) {
            float sampleRate = 16000.0f;
            int sampleSizeInBits = 16;
            int channels = 1;
            boolean signed = true;
            boolean bigEndian = false;
            af = new AudioFormat(sampleRate, sampleSizeInBits, channels, signed, bigEndian);
        } else {
            af = aft.getFormat();
        }
        double[] audio_double = new FDPSOLAProcessor().processDatagram(frames, null, af, null, pScalesArray, tScalesArray, false);
        double MaxSample = MathUtils.getAbsMax((double[])audio_double);
        int i = 0;
        while (i < audio_double.length) {
            audio_double[i] = 0.3 * (audio_double[i] / MaxSample);
            ++i;
        }
        return new DDSAudioInputStream((DoubleDataSource)new BufferedDoubleDataSource(audio_double), af);
    }
}

