/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation.codebook;

import marytts.signalproc.adaptation.BaselineFeatureExtractor;
import marytts.signalproc.adaptation.VocalTractTransformationData;
import marytts.signalproc.adaptation.codebook.WeightedCodebookEntry;
import marytts.signalproc.adaptation.codebook.WeightedCodebookFileHeader;
import marytts.util.string.StringUtils;

public class WeightedCodebook
extends VocalTractTransformationData {
    public static final int SOURCE = 1;
    public static final int TARGET = 2;
    public static final int SOURCE_TARGET = 3;
    public static final int TARGET_SOURCE = 4;
    public WeightedCodebookEntry[] entries;
    public WeightedCodebookFileHeader header;

    public WeightedCodebook() {
        this(0, 0);
    }

    public WeightedCodebook(int totalLsfEntriesIn, int totalF0StatisticsIn) {
        if (this.header == null) {
            this.header = new WeightedCodebookFileHeader(totalLsfEntriesIn);
        }
        this.allocate();
    }

    public void allocate() {
        this.allocate(this.header.totalEntries);
    }

    public void allocate(int totalEntriesIn) {
        if (totalEntriesIn > 0) {
            this.entries = new WeightedCodebookEntry[totalEntriesIn];
            this.header.totalEntries = totalEntriesIn;
        } else {
            this.entries = null;
            this.header.totalEntries = 0;
        }
    }

    public double[][] getFeatures(int speakerType, int desiredFeatures) {
        double[][] features = null;
        if (this.entries != null) {
            features = new double[this.header.totalEntries][];
            int dimension = 0;
            boolean isLsfDesired = false;
            boolean isF0Desired = false;
            boolean isEnergyDesired = false;
            boolean isDurationDesired = false;
            boolean isMfccDesired = false;
            if (StringUtils.isDesired((int)BaselineFeatureExtractor.LSF_FEATURES, (int)desiredFeatures)) {
                dimension += this.header.lsfParams.dimension;
                isLsfDesired = true;
            }
            if (StringUtils.isDesired((int)BaselineFeatureExtractor.F0_FEATURES, (int)desiredFeatures)) {
                ++dimension;
                isF0Desired = true;
            }
            if (StringUtils.isDesired((int)BaselineFeatureExtractor.ENERGY_FEATURES, (int)desiredFeatures)) {
                ++dimension;
                isEnergyDesired = true;
            }
            if (StringUtils.isDesired((int)BaselineFeatureExtractor.DURATION_FEATURES, (int)desiredFeatures)) {
                ++dimension;
                isDurationDesired = true;
            }
            if (StringUtils.isDesired((int)BaselineFeatureExtractor.MFCC_FEATURES_FROM_FILES, (int)desiredFeatures)) {
                dimension += this.header.mfccParams.dimension;
                isMfccDesired = true;
            }
            int i = 0;
            while (i < this.header.totalEntries) {
                features[i] = new double[dimension];
                int currentPos = 0;
                if (speakerType == 1 || speakerType == 3) {
                    if (isLsfDesired && this.entries[i].sourceItem.lsfs != null) {
                        System.arraycopy(this.entries[i].sourceItem.lsfs, 0, features[i], currentPos, this.header.lsfParams.dimension);
                        currentPos += this.header.lsfParams.dimension;
                    }
                    if (isF0Desired) {
                        features[i][currentPos] = this.entries[i].sourceItem.f0;
                        ++currentPos;
                    }
                    if (isEnergyDesired) {
                        features[i][currentPos] = this.entries[i].sourceItem.energy;
                        ++currentPos;
                    }
                    if (isDurationDesired) {
                        features[i][currentPos] = this.entries[i].sourceItem.duration;
                        ++currentPos;
                    }
                    if (isMfccDesired) {
                        System.arraycopy(this.entries[i].sourceItem.mfccs, 0, features[i], currentPos, this.header.mfccParams.dimension);
                        currentPos += this.header.mfccParams.dimension;
                    }
                }
                if (speakerType == 2 || speakerType == 4) {
                    if (isLsfDesired) {
                        System.arraycopy(this.entries[i].targetItem.lsfs, 0, features[i], currentPos, this.header.lsfParams.dimension);
                        currentPos += this.header.lsfParams.dimension;
                    }
                    if (isF0Desired) {
                        features[i][currentPos] = this.entries[i].targetItem.f0;
                        ++currentPos;
                    }
                    if (isEnergyDesired) {
                        features[i][currentPos] = this.entries[i].targetItem.energy;
                        ++currentPos;
                    }
                    if (isDurationDesired) {
                        features[i][currentPos] = this.entries[i].targetItem.duration;
                        ++currentPos;
                    }
                    if (isMfccDesired) {
                        System.arraycopy(this.entries[i].targetItem.mfccs, 0, features[i], currentPos, this.header.mfccParams.dimension);
                        currentPos += this.header.mfccParams.dimension;
                    }
                }
                if (speakerType == 4) {
                    if (isLsfDesired) {
                        System.arraycopy(this.entries[i].sourceItem.lsfs, 0, features[i], currentPos, this.header.lsfParams.dimension);
                        currentPos += this.header.lsfParams.dimension;
                    }
                    if (isF0Desired) {
                        features[i][currentPos] = this.entries[i].sourceItem.f0;
                        ++currentPos;
                    }
                    if (isEnergyDesired) {
                        features[i][currentPos] = this.entries[i].sourceItem.energy;
                        ++currentPos;
                    }
                    if (isDurationDesired) {
                        features[i][currentPos] = this.entries[i].sourceItem.duration;
                        ++currentPos;
                    }
                    if (isMfccDesired) {
                        System.arraycopy(this.entries[i].sourceItem.mfccs, 0, features[i], currentPos, this.header.mfccParams.dimension);
                        currentPos += this.header.mfccParams.dimension;
                    }
                }
                ++i;
            }
        }
        return features;
    }
}

