/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data.audio;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import marytts.signalproc.analysis.EnergyAnalyser_dB;
import marytts.signalproc.analysis.F0TrackerAutocorrelationHeuristic;
import marytts.signalproc.analysis.PitchFileHeader;
import marytts.signalproc.process.EnergyNormaliser;
import marytts.util.Pair;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.AudioConverterUtils;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.io.FileUtils;
import marytts.util.math.MathUtils;
import org.jdesktop.layout.GroupLayout;

public class AudioConverterGUI
extends JFrame {
    private JButton bBrowseInputDir;
    private JButton bBrowseOutputDir;
    private JButton bBrowseSoxPath;
    private JButton bQuit;
    private JButton bRun;
    private ButtonGroup buttonGroup1;
    private JCheckBox cbBestOnly;
    private JCheckBox cbDownsample;
    private JCheckBox cbGlobalAmplitude;
    private JCheckBox cbHighPassFilter;
    private JCheckBox cbPowerNormalise;
    private JCheckBox cbStereoMono;
    private JCheckBox cbTrimSilences;
    private JComboBox comboMaxAmplitude;
    private JComboBox comboSampleRate;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JProgressBar progressBar;
    private JRadioButton rbBoth;
    private JRadioButton rbLeft;
    private JRadioButton rbRight;
    private JTextField tfInputDir;
    private JTextField tfOutputDir;
    private JTextField tfSoxPath;

    public AudioConverterGUI() {
        this.initComponents();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.tfInputDir = new JTextField();
        this.bBrowseInputDir = new JButton();
        this.bBrowseOutputDir = new JButton();
        this.tfOutputDir = new JTextField();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.cbStereoMono = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.cbDownsample = new JCheckBox();
        this.comboSampleRate = new JComboBox();
        this.cbPowerNormalise = new JCheckBox();
        this.cbBestOnly = new JCheckBox();
        this.cbHighPassFilter = new JCheckBox();
        this.cbGlobalAmplitude = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.comboMaxAmplitude = new JComboBox();
        this.jLabel6 = new JLabel();
        this.tfSoxPath = new JTextField();
        this.bBrowseSoxPath = new JButton();
        this.cbTrimSilences = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.rbLeft = new JRadioButton();
        this.rbRight = new JRadioButton();
        this.rbBoth = new JRadioButton();
        this.jLabel4 = new JLabel();
        this.progressBar = new JProgressBar();
        this.bRun = new JButton();
        this.bQuit = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("Speech Synthesis Recordings Audio Converter");
        this.jLabel1.setText("Input Wave directory:");
        this.bBrowseInputDir.setText("Browse");
        this.bBrowseInputDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AudioConverterGUI.this.browseInputDirActionPerformed(evt);
            }
        });
        this.bBrowseOutputDir.setText("Browse");
        this.bBrowseOutputDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AudioConverterGUI.this.browseOutputDirActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Output Wave directory:");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Processing options"));
        this.cbStereoMono.setText("Stereo to Mono conversion");
        this.cbStereoMono.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbStereoMono.setMargin(new Insets(0, 0, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.jPanel1.add((Component)this.cbStereoMono, gridBagConstraints);
        this.jLabel3.setText("Input source channel:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 25, 10, 5);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.cbDownsample.setText("Sampling rate conversion (down-sampling)");
        this.cbDownsample.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbDownsample.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.jPanel1.add((Component)this.cbDownsample, gridBagConstraints);
        this.comboSampleRate.setEditable(true);
        this.comboSampleRate.setModel(new DefaultComboBoxModel<String>(new String[]{"16000", "22050"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.comboSampleRate, gridBagConstraints);
        this.cbPowerNormalise.setText("Power normalisation across recording sessions");
        this.cbPowerNormalise.setToolTipText("Cluster wav files by timestamp, and normalise cluster averages.\n\nWav files recorded with less than 10 minutes gap between them are treated like a single recording session. Only clusters as a whole are normalised, in order to even out different recording volumes in different recording sessions.\n");
        this.cbPowerNormalise.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbPowerNormalise.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 25, 10, 0);
        this.jPanel1.add((Component)this.cbPowerNormalise, gridBagConstraints);
        this.cbBestOnly.setSelected(true);
        this.cbBestOnly.setText("Process only the best take of each sentence");
        this.cbBestOnly.setToolTipText("Process a001.wav, but not a001a.wav, a001b.wav etc.");
        this.cbBestOnly.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbBestOnly.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.jPanel1.add((Component)this.cbBestOnly, gridBagConstraints);
        this.cbHighPassFilter.setSelected(true);
        this.cbHighPassFilter.setText("Remove low-frequency noise below 50 Hz");
        this.cbHighPassFilter.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbHighPassFilter.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.jPanel1.add((Component)this.cbHighPassFilter, gridBagConstraints);
        this.cbGlobalAmplitude.setSelected(true);
        this.cbGlobalAmplitude.setText("Global amplitude scaling");
        this.cbGlobalAmplitude.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbGlobalAmplitude.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.jPanel1.add((Component)this.cbGlobalAmplitude, gridBagConstraints);
        this.jLabel5.setText("Target max. amplitude:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 25, 0, 5);
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        this.comboMaxAmplitude.setEditable(true);
        this.comboMaxAmplitude.setModel(new DefaultComboBoxModel<String>(new String[]{"0.5", "0.6", "0.7", "0.8", "0.9", "1.0 (maximum)", "1.1 (causes clipping)", "1.2 (causes clipping)", "1.3 (causes clipping)", "1.4 (causes clipping)", "1.5 (causes clipping)"}));
        this.comboMaxAmplitude.setSelectedIndex(4);
        this.comboMaxAmplitude.setMinimumSize(new Dimension(70, 28));
        this.comboMaxAmplitude.setPreferredSize(new Dimension(70, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.comboMaxAmplitude, gridBagConstraints);
        this.jLabel6.setText("Location of sox binary:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 25, 10, 5);
        this.jPanel1.add((Component)this.jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.jPanel1.add((Component)this.tfSoxPath, gridBagConstraints);
        this.bBrowseSoxPath.setText("Browse");
        this.bBrowseSoxPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AudioConverterGUI.this.browseSoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.jPanel1.add((Component)this.bBrowseSoxPath, gridBagConstraints);
        this.cbTrimSilences.setSelected(true);
        this.cbTrimSilences.setText("Trim initial and final silences");
        this.cbTrimSilences.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbTrimSilences.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.jPanel1.add((Component)this.cbTrimSilences, gridBagConstraints);
        this.buttonGroup1.add(this.rbLeft);
        this.rbLeft.setSelected(true);
        this.rbLeft.setText("left");
        this.rbLeft.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbLeft.setMargin(new Insets(0, 0, 0, 0));
        this.jPanel2.add(this.rbLeft);
        this.buttonGroup1.add(this.rbRight);
        this.rbRight.setText("right");
        this.rbRight.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbRight.setMargin(new Insets(0, 0, 0, 0));
        this.jPanel2.add(this.rbRight);
        this.buttonGroup1.add(this.rbBoth);
        this.rbBoth.setText("both");
        this.rbBoth.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbBoth.setMargin(new Insets(0, 0, 0, 0));
        this.jPanel2.add(this.rbBoth);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jLabel4.setText("Target sample rate (in Hz):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 25, 0, 5);
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        this.bRun.setText("Run");
        this.bRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AudioConverterGUI.this.runActionPerformed(evt);
            }
        });
        this.bQuit.setText("Quit");
        this.bQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AudioConverterGUI.this.bQuitActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.tfOutputDir, -1, 217, Short.MAX_VALUE).add((Component)this.tfInputDir, -1, 217, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.bBrowseOutputDir).add(2, (Component)this.bBrowseInputDir)).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, 0, 465, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add(80, 80, 80).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.progressBar, -1, 358, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.bRun).addPreferredGap(0, 208, Short.MAX_VALUE).add((Component)this.bQuit))).add(67, 67, 67)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.bBrowseInputDir).addPreferredGap(0).add((Component)this.bBrowseOutputDir)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.tfInputDir, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.tfOutputDir, -2, -1, -2)))).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.progressBar, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.bRun).add((Component)this.bQuit)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void browseSoxActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.tfSoxPath.setText(file.getAbsolutePath());
        }
    }

    private void bQuitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void browseOutputDirActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.tfOutputDir.setText(file.getAbsolutePath());
        }
    }

    private void browseInputDirActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.tfInputDir.setText(file.getAbsolutePath());
        }
    }

    private void runActionPerformed(ActionEvent evt) {
        String inDirPath = this.tfInputDir.getText();
        if (inDirPath.equals("")) {
            JOptionPane.showConfirmDialog(this, "Input directory not specified!", "Info missing", 0, 0);
            return;
        }
        String outDirPath = this.tfOutputDir.getText();
        if (outDirPath.equals("")) {
            JOptionPane.showConfirmDialog(this, "Output directory not specified!", "Info missing", 0, 0);
            return;
        }
        boolean bestOnly = this.cbBestOnly.isSelected();
        boolean stereoMono = this.cbStereoMono.isSelected();
        int whichChannel = 1;
        if (this.rbRight.isSelected()) {
            whichChannel = 2;
        } else if (this.rbBoth.isSelected()) {
            whichChannel = 3;
        }
        boolean downSample = this.cbDownsample.isSelected();
        int targetSampleRate = Integer.parseInt((String)this.comboSampleRate.getSelectedItem());
        String soxPath = this.tfSoxPath.getText();
        if (downSample && !new File(soxPath).exists()) {
            JOptionPane.showConfirmDialog(this, "Please indicate location of 'sox' tool\nor deactivate sample rate conversion.", "Info missing", 0);
            return;
        }
        boolean highPassFilter = this.cbHighPassFilter.isSelected();
        boolean powerNormalise = this.cbPowerNormalise.isSelected();
        boolean maximiseAmplitude = this.cbGlobalAmplitude.isSelected();
        double targetMaxAmplitude = Double.parseDouble(((String)this.comboMaxAmplitude.getSelectedItem()).substring(0, 3));
        boolean trimSilences = this.cbTrimSilences.isSelected();
        if (!(stereoMono || downSample || highPassFilter || powerNormalise || trimSilences)) {
            JOptionPane.showConfirmDialog(this, "Nothing to do!", "Info missing", 0, 0);
            return;
        }
        this.progressBar.setStringPainted(true);
        try {
            new Converter(inDirPath, outDirPath, bestOnly, stereoMono, whichChannel, downSample, targetSampleRate, soxPath, highPassFilter, powerNormalise, maximiseAmplitude, targetMaxAmplitude, trimSilences).start();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.progressBar.setStringPainted(false);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new AudioConverterGUI().setVisible(true);
            }
        });
    }

    public class Converter
    extends Thread {
        private File inDir;
        private File outDir;
        private FilenameFilter filenameFilter;
        private boolean bestOnly;
        private boolean stereoMono;
        private int channel;
        private boolean downSample;
        private int targetSampleRate;
        private String soxPath;
        private boolean highPassFilter;
        private boolean powerNormalise;
        private boolean maximiseAmplitude;
        private double targetMaxAmplitude;
        private boolean trimSilences;

        public Converter(String inDirPath, String outDirPath, final boolean bestOnly, boolean stereoMono, int channel, boolean downSample, int targetSampleRate, String soxPath, boolean highPassFilter, boolean powerNormalise, boolean maximiseAmplitude, double targetMaxAmplitude, boolean trimSilences) throws IOException {
            this.inDir = new File(inDirPath);
            this.outDir = new File(outDirPath);
            if (!this.outDir.exists()) {
                this.outDir.mkdirs();
            }
            this.filenameFilter = new FilenameFilter(){

                @Override
                public boolean accept(File file, String filename) {
                    if (!filename.endsWith(".wav")) {
                        return false;
                    }
                    char lastCharInBasename = filename.charAt(filename.length() - 5);
                    return !bestOnly || lastCharInBasename >= '0' && lastCharInBasename <= '9';
                }
            };
            this.bestOnly = bestOnly;
            this.stereoMono = stereoMono;
            this.channel = channel;
            this.downSample = downSample;
            this.targetSampleRate = targetSampleRate;
            this.soxPath = soxPath;
            this.highPassFilter = highPassFilter;
            this.powerNormalise = powerNormalise;
            this.maximiseAmplitude = maximiseAmplitude;
            this.targetMaxAmplitude = targetMaxAmplitude;
            this.trimSilences = trimSilences;
        }

        @Override
        public void run() {
            int progress = 0;
            int numSteps = 1;
            int stepsComplete = 0;
            if (this.maximiseAmplitude) {
                ++numSteps;
            }
            if (this.powerNormalise) {
                ++numSteps;
            }
            int stepProgress = 100 / numSteps;
            try {
                try {
                    int i;
                    File[] wavFiles = this.inDir.listFiles(this.filenameFilter);
                    System.out.println("Number of wave files to convert: " + wavFiles.length);
                    double[] amplitudeFactors = new double[wavFiles.length];
                    Arrays.fill(amplitudeFactors, 1.0);
                    if (this.powerNormalise) {
                        Arrays.sort(wavFiles, new Comparator<File>(){

                            @Override
                            public int compare(File f1, File f2) {
                                long t2;
                                long t1 = f1.lastModified();
                                if (t1 < (t2 = f2.lastModified())) {
                                    return -1;
                                }
                                if (t1 > t2) {
                                    return 1;
                                }
                                return 0;
                            }

                            @Override
                            public boolean equals(Object obj) {
                                return false;
                            }
                        });
                        ArrayList<Pair> sessions = new ArrayList<Pair>();
                        ArrayList<Double> sessionEnergies = new ArrayList<Double>();
                        double maxEnergy = Double.NEGATIVE_INFINITY;
                        int currentStart = 0;
                        i = 0;
                        while (i < wavFiles.length - 1) {
                            long ti = wavFiles[i].lastModified();
                            long ti1 = wavFiles[i + 1].lastModified();
                            assert (ti1 >= ti);
                            if (ti1 - ti > 600000L) {
                                System.out.println();
                                sessions.add(new Pair((Object)currentStart, (Object)(i + 1)));
                                currentStart = i + 1;
                            }
                            int cfr_ignored_0 = wavFiles.length;
                            ++i;
                        }
                        sessions.add(new Pair((Object)currentStart, (Object)wavFiles.length));
                        i = 0;
                        while (i < sessions.size()) {
                            Pair session = (Pair)sessions.get(i);
                            double avgEnergySession = this.computeAverageEnergy(wavFiles, (Integer)session.getFirst(), (Integer)session.getSecond(), stepsComplete * stepProgress + (Integer)session.getFirst() * stepProgress / wavFiles.length, stepsComplete * stepProgress + (Integer)session.getSecond() * stepProgress / wavFiles.length);
                            System.out.printf(Locale.US, "Session at %tc: %d files, avg. Energy: %f\n", wavFiles[(Integer)session.getFirst()].lastModified(), (Integer)session.getSecond() - (Integer)session.getFirst(), avgEnergySession);
                            sessionEnergies.add(avgEnergySession);
                            if (avgEnergySession > maxEnergy) {
                                maxEnergy = avgEnergySession;
                            }
                            ++i;
                        }
                        int s = 0;
                        int max = sessions.size();
                        while (s < max) {
                            Pair session = (Pair)sessions.get(s);
                            double energy = (Double)sessionEnergies.get(s);
                            if (!(maxEnergy - energy < 1.0E-15)) {
                                double factor = Math.sqrt(Math.pow(10.0, (maxEnergy - energy) / 10.0));
                                System.out.println("Session " + s + " scaling factor: " + factor);
                                int i2 = (Integer)session.getFirst();
                                while (i2 < (Integer)session.getSecond()) {
                                    amplitudeFactors[i2] = factor;
                                    ++i2;
                                }
                            }
                            ++s;
                        }
                        ++stepsComplete;
                    }
                    if (this.maximiseAmplitude) {
                        double globalMaxAmplitude = 0.0;
                        int globalMaxIndex = -1;
                        int i3 = 0;
                        while (i3 < wavFiles.length) {
                            progress = stepsComplete * stepProgress + i3 * stepProgress / wavFiles.length;
                            AudioConverterGUI.this.progressBar.setValue(progress);
                            double maxAmplitude = this.getMaxAbsAmplitude(wavFiles[i3]) * amplitudeFactors[i3];
                            if (maxAmplitude > globalMaxAmplitude) {
                                globalMaxAmplitude = maxAmplitude;
                                globalMaxIndex = i3;
                            }
                            ++i3;
                        }
                        System.out.println("Maximum amplitude of " + globalMaxAmplitude + (this.powerNormalise ? " (after normalisation)" : "") + " found in file " + wavFiles[globalMaxIndex].getName());
                        System.out.println("Target maximum amplitude: " + this.targetMaxAmplitude);
                        double scalingFactor = this.targetMaxAmplitude / globalMaxAmplitude;
                        System.out.println("Applying scaling factor of " + scalingFactor + " to all files");
                        i = 0;
                        while (i < wavFiles.length) {
                            int n = i++;
                            amplitudeFactors[n] = amplitudeFactors[n] * scalingFactor;
                        }
                        ++stepsComplete;
                    }
                    int i4 = 0;
                    while (i4 < wavFiles.length) {
                        double factor;
                        AudioInputStream ais;
                        progress = stepsComplete * stepProgress + i4 * stepProgress / wavFiles.length;
                        AudioConverterGUI.this.progressBar.setValue(progress);
                        String wavFileName = wavFiles[i4].getName();
                        System.out.println(wavFileName);
                        File outFile = new File(this.outDir, wavFileName);
                        if (outFile.exists()) {
                            outFile.delete();
                        }
                        if (!(ais = AudioSystem.getAudioInputStream(wavFiles[i4])).getFormat().getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
                            ais = AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, ais);
                        }
                        if (this.stereoMono) {
                            ais = new AudioConverterUtils.Stereo2Mono(this.channel).apply(ais);
                        }
                        if (this.highPassFilter && ais.getFormat().getChannels() == 1) {
                            ais = new AudioConverterUtils.HighPassFilter(50.0, 40.0).apply(ais);
                        }
                        if ((this.powerNormalise || this.maximiseAmplitude) && (factor = amplitudeFactors[i4]) != 1.0) {
                            ais = new EnergyNormaliser(factor * factor).apply(ais);
                        }
                        AudioSystem.write(ais, AudioFileFormat.Type.WAVE, outFile);
                        ais.close();
                        if (this.trimSilences) {
                            this.trimSilences(outFile);
                        }
                        if (this.downSample) {
                            this.samplingRateConverter(outFile.getAbsolutePath(), this.targetSampleRate);
                        }
                        ++i4;
                    }
                    AudioConverterGUI.this.progressBar.setValue(100);
                    System.out.println("Completed Audio Conversion successfully... Done.");
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                    AudioConverterGUI.this.progressBar.setValue(0);
                    System.err.println("Audio conversion failed for ArrayIndexOutOfBoundsException. Probably this is due because the file lenght is not a multiple of 1024/2048 samples.");
                    AudioConverterGUI.this.progressBar.setStringPainted(false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    AudioConverterGUI.this.progressBar.setValue(0);
                    System.err.println("Audio conversion failed.");
                    AudioConverterGUI.this.progressBar.setStringPainted(false);
                }
            }
            finally {
                AudioConverterGUI.this.progressBar.setStringPainted(false);
            }
        }

        @Deprecated
        private int bestShiftBits(File[] wavFiles, int targetBitsPerSample, int progressMax) throws Exception {
            int globalBestShift = 0;
            int interProgress = AudioConverterGUI.this.progressBar.getValue();
            int stepProgress = progressMax - interProgress;
            int progress = interProgress;
            int i = 0;
            while (i < wavFiles.length) {
                progress = interProgress + i * stepProgress / wavFiles.length;
                AudioConverterGUI.this.progressBar.setValue(progress);
                AudioInputStream ais = AudioSystem.getAudioInputStream(wavFiles[i]);
                if (!ais.getFormat().getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
                    ais = AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, ais);
                }
                if (this.stereoMono) {
                    ais = new AudioConverterUtils.Stereo2Mono(this.channel).apply(ais);
                }
                if (this.highPassFilter && ais.getFormat().getChannels() == 1) {
                    ais = new AudioConverterUtils.HighPassFilter(50.0, 40.0).apply(ais);
                }
                int[] samples = AudioConverterUtils.getSamples(ais);
                int maxBitPos = 0;
                int bitsPerSample = ais.getFormat().getSampleSizeInBits();
                int k = 0;
                while (k < samples.length) {
                    int j = bitsPerSample;
                    while (j >= 1) {
                        int valueAfterShift = Math.abs(samples[k]) >> j;
                        if (valueAfterShift != 0) {
                            if (maxBitPos >= j) break;
                            maxBitPos = j;
                            break;
                        }
                        --j;
                    }
                    ++k;
                }
                ais.close();
                int bestShift = maxBitPos - targetBitsPerSample + 2;
                if (bestShift > globalBestShift) {
                    globalBestShift = bestShift;
                }
                ++i;
            }
            return globalBestShift;
        }

        private void samplingRateConverter(String waveFile, int targetSamplingRate) throws IOException {
            Runtime rtime = Runtime.getRuntime();
            String soxCommandLine = String.valueOf(this.soxPath) + " " + waveFile + " -r " + targetSamplingRate + " tempOut.wav";
            Process process = rtime.exec(soxCommandLine);
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            File outFile = new File("tempOut.wav");
            if (!outFile.renameTo(new File(waveFile))) {
                FileUtils.copy((String)outFile.getAbsolutePath(), (String)waveFile);
            }
        }

        private double computeAverageEnergy(File[] wavFiles, int pos, int end, int progressFrom, int progressTo) throws UnsupportedAudioFileException, IOException {
            int len = end - pos;
            double[] energies = new double[len];
            int i = 0;
            while (i < len) {
                int progress = progressFrom + i * (progressTo - progressFrom) / len;
                AudioConverterGUI.this.progressBar.setValue(progress);
                energies[i] = this.computeAverageEnergy(wavFiles[pos + i]);
                ++i;
            }
            return MathUtils.median(energies);
        }

        /*
         * Unable to fully structure code
         */
        private double computeAverageEnergy(File wavFile) throws UnsupportedAudioFileException, IOException {
            ais = AudioSystem.getAudioInputStream(wavFile);
            sampleRate = (int)ais.getFormat().getSampleRate();
            framelength = (int)(0.01 * (double)sampleRate);
            audioData = new AudioDoubleDataSource(ais).getAllData();
            audio = new BufferedDoubleDataSource(audioData);
            energyAnalyser = new EnergyAnalyser_dB(audio, framelength, sampleRate);
            f0TrackerParams = new PitchFileHeader();
            f0TrackerParams.windowSizeInSeconds = energyAnalyser.getFrameLengthTime();
            f0TrackerParams.skipSizeInSeconds = energyAnalyser.getFrameShiftTime();
            f0TrackerParams.fs = sampleRate;
            f0Tracker = new F0TrackerAutocorrelationHeuristic(f0TrackerParams);
            audio = new BufferedDoubleDataSource(audioData);
            f0Tracker.pitchAnalyze(audio);
            f0Contour = f0Tracker.getF0Contour();
            energyBufferLength = 20;
            speechStartLikelihood = 0.1;
            speechEndLikelihood = 0.1;
            shiftFromMinimumEnergyCenter = 0.1;
            numClusters = 4;
            speechStretches = energyAnalyser.getSpeechStretchesUsingEnergyHistory(energyBufferLength, speechStartLikelihood, speechEndLikelihood, shiftFromMinimumEnergyCenter, numClusters);
            energies = energyAnalyser.analyseAllFrames();
            numSpeechFrames = 0;
            numFrames = Math.min(energies.length, f0Contour.length);
            speechFrameEnergies = new double[numFrames];
            iCurrentFrame = 0;
            i = 0;
            ** GOTO lbl38
            {
                ++iCurrentFrame;
                do {
                    if (iCurrentFrame < numFrames && energies[iCurrentFrame].getStartTime() < speechStretches[i][0]) continue block0;
                    while (iCurrentFrame < numFrames && energies[iCurrentFrame].getStartTime() < speechStretches[i][1]) {
                        if (f0Contour[iCurrentFrame] > 10.0) {
                            speechFrameEnergies[numSpeechFrames] = (Double)energies[iCurrentFrame].get();
                            ++numSpeechFrames;
                        }
                        ++iCurrentFrame;
                    }
                    ++i;
lbl38:
                    // 2 sources

                } while (i < speechStretches.length);
            }
            if (numSpeechFrames == 0) {
                System.err.println("No speech found in file " + wavFile.getAbsolutePath());
                return 0.0;
            }
            medianSpeechFrameEnergy = MathUtils.median(speechFrameEnergies, 0, numSpeechFrames);
            medianSpeechSampleEnergy = medianSpeechFrameEnergy / (double)energyAnalyser.getFrameLengthSamples();
            return medianSpeechSampleEnergy;
        }

        private double getMaxAbsAmplitude(File wavFile) throws UnsupportedAudioFileException, IOException {
            double maxAmplitude = 0.0;
            AudioInputStream ais = AudioSystem.getAudioInputStream(wavFile);
            double[] audioData = new AudioDoubleDataSource(ais).getAllData();
            int i = 0;
            while (i < audioData.length) {
                if (audioData[i] > maxAmplitude || -audioData[i] > maxAmplitude) {
                    maxAmplitude = Math.abs(audioData[i]);
                }
                ++i;
            }
            ais.close();
            return maxAmplitude;
        }

        private void trimSilences(File wavFile) throws UnsupportedAudioFileException, IOException {
            int energyBufferLength = 20;
            double speechStartLikelihood = 0.1;
            double speechEndLikelihood = 0.1;
            double shiftFromMinimumEnergyCenter = 0.0;
            int numClusters = 4;
            double minimumStartSilenceInSeconds = 0.5;
            double minimumEndSilenceInSeconds = 0.5;
            File tmpFile = new File("tmpAudio.wav");
            AudioConverterUtils.removeEndpoints(wavFile.getAbsolutePath(), tmpFile.getAbsolutePath(), energyBufferLength, speechStartLikelihood, speechEndLikelihood, shiftFromMinimumEnergyCenter, numClusters, minimumStartSilenceInSeconds, minimumEndSilenceInSeconds);
            if (!tmpFile.renameTo(wavFile)) {
                FileUtils.copy((String)tmpFile.getAbsolutePath(), (String)wavFile.getAbsolutePath());
            }
        }
    }
}

