/*
 * Decompiled with CFR 0.152.
 */
package org.jsresources;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import org.jsresources.AudioCommon;

public class AudioRecorder {
    private static final SupportedFormat[] SUPPORTED_FORMATS = new SupportedFormat[]{new SupportedFormat("s8", AudioFormat.Encoding.PCM_SIGNED, 8, true), new SupportedFormat("u8", AudioFormat.Encoding.PCM_UNSIGNED, 8, true), new SupportedFormat("s16_le", AudioFormat.Encoding.PCM_SIGNED, 16, false), new SupportedFormat("s16_be", AudioFormat.Encoding.PCM_SIGNED, 16, true), new SupportedFormat("u16_le", AudioFormat.Encoding.PCM_UNSIGNED, 16, false), new SupportedFormat("u16_be", AudioFormat.Encoding.PCM_UNSIGNED, 16, true), new SupportedFormat("s24_le", AudioFormat.Encoding.PCM_SIGNED, 24, false), new SupportedFormat("s24_be", AudioFormat.Encoding.PCM_SIGNED, 24, true), new SupportedFormat("u24_le", AudioFormat.Encoding.PCM_UNSIGNED, 24, false), new SupportedFormat("u24_be", AudioFormat.Encoding.PCM_UNSIGNED, 24, true), new SupportedFormat("s32_le", AudioFormat.Encoding.PCM_SIGNED, 32, false), new SupportedFormat("s32_be", AudioFormat.Encoding.PCM_SIGNED, 32, true), new SupportedFormat("u32_le", AudioFormat.Encoding.PCM_UNSIGNED, 32, false), new SupportedFormat("u32_be", AudioFormat.Encoding.PCM_UNSIGNED, 32, true)};
    private static final String DEFAULT_FORMAT = "s16_le";
    private static final int DEFAULT_CHANNELS = 2;
    private static final float DEFAULT_RATE = 44100.0f;
    private static final AudioFileFormat.Type DEFAULT_TARGET_TYPE = AudioFileFormat.Type.WAVE;
    private static boolean sm_bDebug = false;

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        strMixerName = null;
        nInternalBufferSize = -1;
        strFormat = "s16_le";
        nChannels = 2;
        fRate = 44100.0f;
        strExtension = null;
        bDirectRecording = true;
        millis = 0;
        if (args.length < 1) {
            AudioRecorder.printUsageAndExit();
        }
        strFilename = null;
        i = 0;
        while (i < args.length) {
            if (args[i].startsWith("-")) ** GOTO lbl19
            if (i == args.length - 1) {
                strFilename = args[i];
            } else {
                AudioRecorder.printUsageAndExit();
lbl19:
                // 2 sources

                if (args[i].length() != 2) {
                    AudioRecorder.printUsageAndExit();
                }
                switch (args[i].charAt(1)) {
                    case 'h': {
                        AudioRecorder.printUsageAndExit();
                    }
                    case 'l': {
                        AudioCommon.listMixersAndExit();
                    }
                    case 'L': {
                        AudioRecorder.listTargetDataLines();
                        System.exit(0);
                    }
                    case 'M': {
                        strMixerName = args[++i];
                        if (!AudioRecorder.sm_bDebug) break;
                        AudioRecorder.out("AudioRecorder.main(): mixer name: " + strMixerName);
                        break;
                    }
                    case 'i': {
                        nInternalBufferSize = Integer.parseInt(args[++i]);
                        break;
                    }
                    case 'f': {
                        strFormat = args[++i].toLowerCase();
                        break;
                    }
                    case 'c': {
                        nChannels = Integer.parseInt(args[++i]);
                        break;
                    }
                    case 'r': {
                        fRate = Float.parseFloat(args[++i]);
                        break;
                    }
                    case 't': {
                        strExtension = args[++i];
                        break;
                    }
                    case 'D': {
                        AudioRecorder.sm_bDebug = true;
                        AudioCommon.setDebug(true);
                        AudioRecorder.out("AudioRecorder.main(): enabled debug messages");
                        break;
                    }
                    case 'd': {
                        bDirectRecording = true;
                        AudioRecorder.out("AudioRecorder.main(): using direct recording");
                        break;
                    }
                    case 'b': {
                        bDirectRecording = false;
                        AudioRecorder.out("AudioRecorder.main(): using buffered recording");
                        break;
                    }
                    case '?': {
                        AudioRecorder.printUsageAndExit();
                    }
                    case 'T': {
                        millis = Integer.parseInt(args[++i]);
                        break;
                    }
                    default: {
                        AudioRecorder.out("unknown option: " + args[i]);
                        AudioRecorder.printUsageAndExit();
                    }
                }
            }
            ++i;
        }
        if (AudioRecorder.sm_bDebug) {
            AudioRecorder.out("AudioRecorder.main(): output filename: " + strFilename);
        }
        if (strFilename == null) {
            AudioRecorder.printUsageAndExit();
        }
        outputFile = new File(strFilename);
        if (strFormat.equals("phone")) {
            fRate = 8000.0f;
            strFormat = "u8";
            nChannels = 1;
        } else if (strFormat.equals("radio")) {
            fRate = 22050.0f;
            strFormat = "s16_le";
            nChannels = 1;
        } else if (strFormat.equals("cd")) {
            fRate = 44100.0f;
            strFormat = "s16_le";
            nChannels = 2;
        } else if (strFormat.equals("dat")) {
            fRate = 48000.0f;
            strFormat = "s16_le";
            nChannels = 2;
        }
        nOutputFormatIndex = -1;
        i = 0;
        while (i < AudioRecorder.SUPPORTED_FORMATS.length) {
            if (AudioRecorder.SUPPORTED_FORMATS[i].getName().equals(strFormat)) {
                nOutputFormatIndex = i;
                break;
            }
            ++i;
        }
        if (nOutputFormatIndex == -1) {
            AudioRecorder.out("warning: output format '" + strFormat + "' not supported; using default output format '" + "s16_le" + "'");
            nOutputFormatIndex = 2;
        }
        encoding = AudioRecorder.SUPPORTED_FORMATS[nOutputFormatIndex].getEncoding();
        nBitsPerSample = AudioRecorder.SUPPORTED_FORMATS[nOutputFormatIndex].getSampleSize();
        bBigEndian = AudioRecorder.SUPPORTED_FORMATS[nOutputFormatIndex].getBigEndian();
        nFrameSize = nBitsPerSample / 8 * nChannels;
        audioFormat = new AudioFormat(encoding, fRate, nBitsPerSample, nChannels, nFrameSize, fRate, bBigEndian);
        if (AudioRecorder.sm_bDebug) {
            AudioRecorder.out("AudioRecorder.main(): target audio format: " + audioFormat);
        }
        targetType = null;
        if (strExtension == null && (nDotPosition = strFilename.lastIndexOf(46)) != -1) {
            strExtension = strFilename.substring(nDotPosition + 1);
        }
        if (strExtension != null) {
            targetType = AudioCommon.findTargetType(strExtension);
            if (targetType == null) {
                AudioRecorder.out("target type '" + strExtension + "' is not supported.");
                AudioRecorder.out("using default type '" + AudioRecorder.DEFAULT_TARGET_TYPE.getExtension() + "'");
                targetType = AudioRecorder.DEFAULT_TARGET_TYPE;
            }
        } else {
            AudioRecorder.out("target type is neither specified nor can be guessed from the target file name.");
            AudioRecorder.out("using default type '" + AudioRecorder.DEFAULT_TARGET_TYPE.getExtension() + "'");
            targetType = AudioRecorder.DEFAULT_TARGET_TYPE;
        }
        if (AudioRecorder.sm_bDebug) {
            AudioRecorder.out("AudioRecorder.main(): target audio file format type: " + targetType);
        }
        targetDataLine = null;
        targetDataLine = AudioCommon.getTargetDataLine(strMixerName, audioFormat, nInternalBufferSize);
        if (targetDataLine == null) {
            AudioRecorder.out("can't get TargetDataLine, exiting.");
            System.exit(1);
        }
        recorder = null;
        recorder = millis > 0 ? new BufferingRecorder(targetDataLine, targetType, outputFile, millis) : (bDirectRecording != false ? new DirectRecorder(targetDataLine, targetType, outputFile) : new BufferingRecorder(targetDataLine, targetType, outputFile, 0));
        if (AudioRecorder.sm_bDebug) {
            AudioRecorder.out("AudioRecorder.main(): Recorder: " + recorder);
        }
        AudioRecorder.out("Press ENTER to start the recording.");
        try {
            System.in.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        recorder.start();
        AudioRecorder.out("Recording...");
        AudioRecorder.out("Press ENTER to stop the recording.");
        try {
            System.in.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        recorder.stopRecording();
        AudioRecorder.out("Recording stopped.");
    }

    private static void listTargetDataLines() {
        AudioRecorder.out("Available Mixers:");
        Mixer.Info[] aInfos = AudioSystem.getMixerInfo();
        int i = 0;
        while (i < aInfos.length) {
            Mixer mixer = AudioSystem.getMixer(aInfos[i]);
            Line.Info[] lines = mixer.getTargetLineInfo();
            AudioRecorder.out(aInfos[i].getName());
            int j = 0;
            while (j < lines.length) {
                AudioRecorder.out("  " + lines[j].toString());
                if (lines[j] instanceof DataLine.Info) {
                    AudioFormat[] formats = ((DataLine.Info)lines[j]).getFormats();
                    int k = 0;
                    while (k < formats.length) {
                        AudioRecorder.out("    " + formats[k].toString());
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private static void printUsageAndExit() {
        AudioRecorder.out("AudioRecorder: usage:");
        AudioRecorder.out("\tjava AudioRecorder -l");
        AudioRecorder.out("\tjava AudioRecorder -L");
        AudioRecorder.out("\tjava AudioRecorder [-f <format>] [-c <numchannels>] [-r <samplingrate>] [-t <targettype>] [-M <mixername>] <soundfile>");
        System.exit(0);
    }

    private static void out(String strMessage) {
        System.out.println(strMessage);
    }

    public static class AbstractRecorder
    extends Thread
    implements Recorder {
        protected TargetDataLine m_line;
        protected AudioFileFormat.Type m_targetType;
        protected File m_file;
        protected boolean m_bRecording;

        public AbstractRecorder(TargetDataLine line, AudioFileFormat.Type targetType, File file) {
            this.m_line = line;
            this.m_targetType = targetType;
            this.m_file = file;
        }

        @Override
        public void start() {
            this.m_line.start();
            super.start();
        }

        @Override
        public void stopRecording() {
            this.m_line.drain();
            this.m_line.stop();
            this.m_line.close();
            this.m_bRecording = false;
        }

        public void stopRecordingNOW() {
            this.m_line.stop();
            this.m_line.close();
            this.m_bRecording = false;
        }
    }

    public static class BufferingRecorder
    extends AbstractRecorder {
        private int millis;

        public BufferingRecorder(TargetDataLine line, AudioFileFormat.Type targetType, File file, int millis) {
            super(line, targetType, file);
            this.millis = millis;
        }

        @Override
        public void run() {
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream outputStream = byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] abBuffer = new byte[65532];
            AudioFormat format = this.m_line.getFormat();
            int nFrameSize = format.getFrameSize();
            long totalBytesToRead = (long)((float)this.millis * format.getFrameRate() * (float)nFrameSize / 1000.0f);
            if (totalBytesToRead % (long)nFrameSize != 0L) {
                totalBytesToRead += (long)nFrameSize - totalBytesToRead % (long)nFrameSize;
            }
            long totalBytes = 0L;
            this.m_bRecording = true;
            while (this.m_bRecording) {
                int bytesToRead = abBuffer.length;
                if (totalBytesToRead > 0L && totalBytes + (long)abBuffer.length > totalBytesToRead) {
                    bytesToRead = (int)(totalBytesToRead - totalBytes);
                }
                if (sm_bDebug) {
                    AudioRecorder.out("BufferingRecorder.run(): trying to read: " + bytesToRead);
                }
                int nBytesRead = this.m_line.read(abBuffer, 0, bytesToRead);
                if (totalBytesToRead > 0L && (totalBytes += (long)nBytesRead) >= totalBytesToRead) {
                    this.m_bRecording = false;
                }
                if (sm_bDebug) {
                    AudioRecorder.out("BufferingRecorder.run(): read: " + nBytesRead);
                }
                try {
                    ((OutputStream)outputStream).write(abBuffer, 0, nBytesRead);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            byte[] abData = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(abData);
            AudioInputStream audioInputStream = new AudioInputStream(byteArrayInputStream, format, abData.length / format.getFrameSize());
            try {
                AudioSystem.write(audioInputStream, this.m_targetType, this.m_file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class DirectRecorder
    extends AbstractRecorder {
        private AudioInputStream m_audioInputStream;

        public DirectRecorder(TargetDataLine line, AudioFileFormat.Type targetType, File file) {
            super(line, targetType, file);
            this.m_audioInputStream = new AudioInputStream(line);
        }

        @Override
        public void run() {
            try {
                if (sm_bDebug) {
                    AudioRecorder.out("before AudioSystem.write");
                }
                AudioSystem.write(this.m_audioInputStream, this.m_targetType, this.m_file);
                if (sm_bDebug) {
                    AudioRecorder.out("after AudioSystem.write");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static interface Recorder {
        public void start();

        public void stopRecording();
    }

    private static class SupportedFormat {
        private String m_strName;
        private AudioFormat.Encoding m_encoding;
        private int m_nSampleSize;
        private boolean m_bBigEndian;

        public SupportedFormat(String strName, AudioFormat.Encoding encoding, int nSampleSize, boolean bBigEndian) {
            this.m_strName = strName;
            this.m_encoding = encoding;
            this.m_nSampleSize = nSampleSize;
        }

        public String getName() {
            return this.m_strName;
        }

        public AudioFormat.Encoding getEncoding() {
            return this.m_encoding;
        }

        public int getSampleSize() {
            return this.m_nSampleSize;
        }

        public boolean getBigEndian() {
            return this.m_bBigEndian;
        }
    }
}

